using System;

[System.AttributeUsage(System.AttributeTargets.Field | System.AttributeTargets.Method)]
class MonCustomAttribute : System.Attribute {
	public string LeType;
	public string LaDate;

	public MonCustomAttribute() {
		LeType = "Chaine";
		LaDate = @"--\--\--";
	}

	public MonCustomAttribute(string p) {
		LeType = p;
		LaDate = @"--\--\--";
	}
}


[MonCustom("Classe")]
class Personne {
	[MonCustom] public string Nom;
	[MonCustom("Chaine")] public string Prenom;
	[MonCustom("Entier", LaDate="5/6/68")] public int Age;

	public void Show() {
		Console.WriteLine("Nom: {0}, Prenom: {1}, Age: {2}", Nom, Prenom, Age);
	}
}

public class CustomAttribute {
	public static void Main() {

		Personne p = new Personne();
		p.Nom="Durant";
		p.Prenom="Paul";
		p.Age=56;

		// Information sur les attributs de la classe
		Console.WriteLine("Informations lies  la classe");
		Type type = p.GetType();

		ShowAttributes(type.GetCustomAttributes(typeof(MonCustomAttribute), false));


		// Information sur les donnes membre de la classe
		Console.WriteLine("Informations lies aux donnes membre de la classe");
		System.Reflection.FieldInfo[] fs = type.GetFields();
		foreach(System.Reflection.FieldInfo f in fs)
			ShowAttributes(f.GetCustomAttributes(typeof(MonCustomAttribute), false));
	}

	public static void ShowAttributes(Object[] attributs) {
		foreach(MonCustomAttribute mca in attributs) {
			Console.WriteLine("Type: {0}", mca.LeType);
			Console.WriteLine("Date: {0}", mca.LaDate);
		}
	}
}