using System;
using System.Reflection;


public class DynamicLoad {
	public static void Main(String [] args) {
		if(args.Length!=1) 
			throw new Exception("Syntaxe : DynamicLoad [Fichier.dll | Fichier.exe]");

		Assembly assembly = Assembly.LoadFrom(args[0]);
		System.Console.WriteLine("Chargement de l'assembly : OK");

		foreach (Module module in assembly.GetModules()) {
			Console.WriteLine("Module : {0}", module.Name);

			foreach (Type type in module.GetTypes()) {
				Console.WriteLine("Type: {0}, Nom: {1}", GetModuleName(type), type.FullName);

				foreach (MemberInfo member in type.GetMembers())
					Console.WriteLine("--> {0}.{1}", type.FullName, member.Name);
			}
		}
	}

	public static string GetModuleName(Type t) {
		if(t.IsClass) return "Classe";
		else
		if(t.IsInterface) return "Interface";
		else
		if(t.IsArray) return "Tableau";
		else
		if(t.IsEnum) return "Enumration";
		else
			return "Autre type...";
	}
}