using System;

class Test {
	private string destination;

	public Test() {
		destination = "Paris";
	}

	public Test(string dest) {
		destination = dest;
	}

	public void Go() {
		Console.WriteLine("Go !"+destination);
	}

	public void Go(string where) {
		Console.WriteLine("Go "+where);
	}
}

class Class1
{
	static void Main(string[] args)
	{
		CallMethodGoVoid();		
		CallMethodGoParam();

		CallGoVoidConstruct();
	}

	static void CallMethodGoVoid() {
		Type typeTest = typeof(Test);

		System.Reflection.Assembly assembly = System.Reflection.Assembly.GetExecutingAssembly();

		object typeGoInstance = assembly.CreateInstance("Test");

		System.Reflection.MethodInfo methodGo =	typeTest.GetMethod("Go", new Type[] {});

		methodGo.Invoke(typeGoInstance, null);
	}

	static void CallMethodGoParam() {
		Type typeTest = typeof(Test);

		System.Reflection.Assembly assembly = System.Reflection.Assembly.GetExecutingAssembly();

		object typeGoInstance = assembly.CreateInstance("Test");

		System.Reflection.MethodInfo methodGo =	typeTest.GetMethod("Go", new Type[] {typeof(string)});

		methodGo.Invoke(typeGoInstance, new object[] {"Salut"});
	}

	static void CallGoVoidConstruct() {
		Type typeTest = typeof(Test);

		System.Reflection.Assembly assembly = System.Reflection.Assembly.GetExecutingAssembly();

		System.Reflection.ConstructorInfo constructor = typeTest.GetConstructor(new Type[] {typeof(string)});

		object instance = constructor.Invoke(new object[] {"Marseille"});

		System.Reflection.MethodInfo methodGo =	typeTest.GetMethod("Go", new Type[] {});

		methodGo.Invoke(instance, null);
	}
}