using System;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Http;


class Person : MarshalByRefObject, IPerson {
	public int GetAgeFromYear(int year) {
		return System.DateTime.Now.Year - year;
	}
}


class Server {
	static void Main() {
		ChannelServices.RegisterChannel(new HttpChannel(999));

		RemotingConfiguration.RegisterWellKnownServiceType(
		typeof(Person), "personsrv",
		WellKnownObjectMode.SingleCall );

		Console.WriteLine("Appuyez sur Entree pour arrter le serveur...");
		Console.ReadLine();
	}
}