using System;
using Microsoft.Win32;
using System.Security.Permissions;


[assembly:PermissionSetAttribute(SecurityAction.RequestMinimum, File = "security.xml")]


public class ConsoleApp {
    public static int Main(string[] args) {
        //Rcupration des URL dans 
        //HKCU\\SOFTWARE\\MICROSOFT\\INTERNET EXPLORER\\TYPEDURLS
        RegistryKey Hkcu = Registry.CurrentUser ;
        RegistryKey keySoftware = Hkcu.OpenSubKey("SOFTWARE");
        RegistryKey keyMS = keySoftware.OpenSubKey("Microsoft");
        RegistryKey keyIE = keyMS.OpenSubKey("Internet Explorer");
        RegistryKey keyUrls = keyIE.OpenSubKey("TypedURLs");

        //Now get all the values in the key...
        long lCount = keyUrls.ValueCount;
        if(lCount <= 0) return 1;

        Console.WriteLine ("Voici l'historique des Urls saisies dans IE");

        int i = 1;
        string [] IEUrls = keyUrls.GetValueNames();        
        foreach(string IEUrl in IEUrls) {
            Console.WriteLine ("[{0}] {1}", i++, keyUrls.GetValue(IEUrl));
        }
        return 0;
    }
}