using System;
using System.Runtime.Serialization;

namespace SimpleSerialization
{
	[System.Serializable]
	class Personne : ISerializable
	{
		private int id;
		public int Id {
			get { return id; }
			set { id = value; }
		}

		private string name;
		public string Name {
			get { return name; }
			set { name = value; }
		}

		private int age;
		public int Age {
			get { return age; }
			set { 
				age = value; 
				PopulateFlags();
		}
		}

		[NonSerialized]
		private bool [] AgeFlags;


		public Personne(int id, string name, int age) {
			this.id = id;
			this.name = name;
			this.age = age;

			PopulateFlags();
		}

		private void PopulateFlags(){
			AgeFlags = new bool[130];
			AgeFlags[age] = true;
		}

		public void Show() {
			Console.WriteLine("Id:{0}, name:{1}, age:{2}", id, name, age);
		}

		#region Implementation of ISerializable
		// Cette mthode est appele lors de la srialisation
		public void GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) {
			info.AddValue("id", id);
			info.AddValue("name", name);
			info.AddValue("age", age);
		}
		#endregion

		// Ce constructeur est appell lors de la dsrialisation
		public Personne(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) {
			id = info.GetInt32("id");
			name = info.GetString("name");
			age = info.GetInt32("age");

			PopulateFlags();
		}
	}
}
