using System;

using Serialisation = System.Runtime.Serialization;


[System.Serializable]
public class Personne : Serialisation.ISerializable {

	public string Nom;
	public string Prenom;
	[System.NonSerialized] public int Age;

	public void Show() {
		Console.WriteLine("Nom: {0}, Prnom: {1}, Age: {2}",
			Nom, Prenom, Age);
	}


	public Personne() {
		// important sinon une exception est souleve
	}

	public Personne(Serialisation.SerializationInfo info,
		 Serialisation.StreamingContext context) {
		// Dsrialisation
		Console.WriteLine("Int: "+info.GetInt32("UneValeurInt"));
		Console.WriteLine("Str: "+info.GetString("UneValeurStr"));
		Prenom = info.GetString("Prenom");
	}

	public virtual void GetObjectData(Serialisation.SerializationInfo info,
		 Serialisation.StreamingContext context) {
		// Srialisation
		info.AddValue("UneValeurInt", 90);
		info.AddValue("UneValeurStr", "Bonjour"); 
		info.AddValue("Prenom", Prenom);
	}
}