using System;
using System.Runtime.Serialization;
using System.IO;
using System.Runtime.Serialization.Formatters.Soap;

[System.Serializable]
public class Bombe
{
	private int maxValue;

	private int compteur;
	public int Compteur {
		get { return compteur; }
		set { compteur = value; }
	}

	public Bombe(int m)
	{
		maxValue = m; compteur = m;
	}

	public void MoinsUn() {
		compteur -=1;

		if(compteur==0) {
			Console.WriteLine("EXPLOSION !");

			compteur = maxValue;
		}
		else Show();
	}

	public void Show() {
		string s = "Il reste {0} unit(s) avant l'explosion...";
		Console.WriteLine(String.Format(s, compteur));
	}

	public static Bombe GetBombeObject() {
		Bombe bombe;
		try {
			FileStream fs = new FileStream("Bombe.ser", FileMode.Open);

			SoapFormatter sf = new SoapFormatter();
			bombe = (Bombe)sf.Deserialize(fs);
			fs.Close();
		}
		catch {
			bombe = new Bombe(4);
		}
		return bombe;
	}

	public static void PersistBombeObject(Bombe bombe) {
		FileStream fs = new FileStream("Bombe.ser", FileMode.Create);

		SoapFormatter sf = new SoapFormatter();
		sf.Serialize(fs, bombe);
		fs.Close();
	}
}