using System;

namespace SimpleSerialization
{
	[System.Serializable]
	class Personne
	{
		private int id;
		public int Id {
			get { return id; }
			set { id = value; }
		}

		private string name;
		public string Name {
			get { return name; }
			set { name = value; }
		}

		private int age;
		public int Age {
			get { return age; }
			set { 
				age = value; 
				PopulateFlags();
		}
		}

		[NonSerialized]
		private bool [] AgeFlags;


		public Personne(int id, string name, int age) {
			this.id = id;
			this.name = name;
			this.age = age;

			PopulateFlags();
		}

		private void PopulateFlags(){
			AgeFlags = new bool[130];
			AgeFlags[age] = true;
		}

		public void Show() {
			Console.WriteLine("Id:{0}, name:{1}, age:{2}", id, name, age);
		}
	}
}
