using System;
using System.Windows.Forms;



public class SpyMessages : System.Windows.Forms.IMessageFilter {
	private ListBox listbox;

	public SpyMessages(ListBox lb) {
		listbox = lb;
	}

	public bool PreFilterMessage(ref Message m) {
		listbox.Items.Add(m.ToString());

		return false;
	}
}

public class SpyForm : Form {
	private ListBox lstMessages;

	public SpyForm() {
		lstMessages = new ListBox();
		lstMessages.Dock = DockStyle.Fill;		

		Controls.Add(lstMessages);

		Application.AddMessageFilter(new SpyMessages(lstMessages));
	}

	public static void Main() {
		Application.Run(new SpyForm());
	}
}

