using System;
using System.Drawing;
using System.Drawing.Printing;
using System.Windows.Forms;


public class PrintDialogTest : Form {

	private Button btnPrint;
	private PrintDocument prnDoc;
	private PrintPreviewDialog prnPreviewDlg;

	public PrintDialogTest() {
		prnDoc = new PrintDocument();
		prnDoc.PrintPage += new PrintPageEventHandler(prnDoc_PrintPage);
		
		prnPreviewDlg = new PrintPreviewDialog();
		prnPreviewDlg.Document = prnDoc;

		btnPrint = new Button();
		btnPrint.Text = "Prvisualisation"; 
		btnPrint.Width = 100;
		btnPrint.Click +=new EventHandler(PrintClic);
		Controls.Add(btnPrint);
	}

	private void PrintClic(object Sender, EventArgs e) {
		prnPreviewDlg.ShowDialog();			
	}

	private void prnDoc_PrintPage(object sender, PrintPageEventArgs e)
	{
		e.Graphics.DrawEllipse(Pens.Black, 10, 10, 100, 100);
		e.Graphics.DrawString("Un cercle...", this.Font, Brushes.BlueViolet, 20, 50);
	}

	public static void Main() {
		Application.Run(new PrintDialogTest());
	}
}