using System;
using System.Windows.Forms;


public class DragDropTest : Form {
	
	private ListBox lstKeyword;
	private RichTextBox rtfTexte;	

	public DragDropTest() {
		Text = "Application exemple de Drag&Drop de texte";
		Width = 518; Height = 238;

		lstKeyword = new ListBox();
		lstKeyword.Left = 4; lstKeyword.Top = 4;
		lstKeyword.Width = 100; lstKeyword.Height = 200;
		lstKeyword.Items.Add("foreach");
		lstKeyword.Items.Add("public");
		lstKeyword.Items.Add("void");
		lstKeyword.MouseDown += new MouseEventHandler(lstKeyword_MouseDown);

		Controls.Add(lstKeyword);

		rtfTexte = new RichTextBox();
		rtfTexte.Left = 104; rtfTexte.Top = 4;
		rtfTexte.Width = 400; rtfTexte.Height = 200;
		rtfTexte.AllowDrop = true;
		rtfTexte.DragEnter += new DragEventHandler(rtfTexte_DragEnter);
		rtfTexte.DragDrop += new DragEventHandler(rtfTexte_DragDrop);
		Controls.Add(rtfTexte);
	}

	private void lstKeyword_MouseDown(object sender, MouseEventArgs e) 
	{
		lstKeyword.DoDragDrop(lstKeyword.Items[lstKeyword.SelectedIndex], DragDropEffects.Copy);
	}

	private void rtfTexte_DragEnter(object sender, DragEventArgs e) 
	{
		if(e.Data.GetDataPresent(DataFormats.Text)) {
			e.Effect = DragDropEffects.Copy;
		}
		else
			e.Effect = DragDropEffects.None;
	}

	private void rtfTexte_DragDrop(object sender, DragEventArgs e) 
	{
		rtfTexte.SelectedText = (string)e.Data.GetData(DataFormats.Text);
	}


	public static void Main() {
		Application.Run(new DragDropTest());
	}
}