using System;
using System.IO;
using System.Windows.Forms;

public class TestFileSystemWatcher : Form {

	private ListBox lstBox;
	private FileSystemWatcher fileSysWatcher;


	public TestFileSystemWatcher() {
		lstBox = new ListBox();
		lstBox.Dock = DockStyle.Fill;
		Controls.Add(lstBox);		

		fileSysWatcher = new FileSystemWatcher();
		fileSysWatcher.Filter = "*.txt";
		fileSysWatcher.IncludeSubdirectories = false;
		fileSysWatcher.Path = @"c:\";
		fileSysWatcher.Changed += new System.IO.FileSystemEventHandler(fileChanged);

		fileSysWatcher.EnableRaisingEvents = true;
		//fileSysWatcher.SynchronizingObject = this;
		

	}

	private void fileChanged(object sender, System.IO.FileSystemEventArgs e) {
		string s = String.Format("File [{0}] changed", e.FullPath);
		lstBox.Items.Add(s);
	}


	public static void Main() {
		Application.Run(new TestFileSystemWatcher());
	}

}



//Office 2000 Premium s/n: DT3FT-BFH4M-GYYH8-PG9C3-8K2FJ
//Fox & Dana dit :
// s/n: MP4F9 W6C8V HTCCT T7MR Y7K3Y
