using System;
using System.Windows.Forms;
using System.Drawing.Printing;


public class GDIPrinterApplication : Form {

	private PrintDocument printDocument;

	public GDIPrinterApplication() {
		printDocument = new PrintDocument();
		printDocument.PrintPage += new System.Drawing.Printing.PrintPageEventHandler(printDocument_PrintPage);

		Paint += new PaintEventHandler(this.FormPaint);
	}

	private void FormPaint(object sender, PaintEventArgs e){
		e.Graphics.DrawEllipse(System.Drawing.Pens.Black, 10, 10, 100, 100);
		e.Graphics.DrawString("Un cercle...", this.Font, System.Drawing.Brushes.BlueViolet, 20, 50);
	}

	public static void Main() {
		Application.Run(new GDIPrinterApplication());
	}


	private void DrawCanvas(System.Drawing.Graphics g) 
	{
		g.DrawEllipse(System.Drawing.Pens.Black, 10, 10, 100, 100);
		g.DrawString("Un cercle...", this.Font, System.Drawing.Brushes.BlueViolet, 20, 50);

	}

	private void printDocument_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
	{
		DrawCanvas(e.Graphics);
	}
}