using System;
using System.Windows.Forms;

class MDIFille : Form {
	public MDIFille() {
		Text = "Fentre fille...";
	}
}


public class MDIApplication : Form {
	private MainMenu MnuPrincipal;
	private MenuItem MnuFichier;
	private MenuItem MnuAide;
	private MenuItem MnuFichier_Fenetre;
	private MenuItem MnuFichier_Quitter;
	private MenuItem MnuAide_APropos;

	private MenuItem MnuEdition;
	private MenuItem MnuEdition_Copier;
	private MenuItem MnuEdition_Coller;	
	private MenuItem MnuEdition_Couper;

	private MenuItem MnuSeparation;

	private ToolBar toolBar;
        private ToolBarButton toolBarCouper;
        private ToolBarButton toolBarCopier;
        private ToolBarButton toolBarColler;

	private StatusBar statusBar;


	public MDIApplication() {
		Text = "Mon application MDI";
		IsMdiContainer = true;


            	toolBarCouper = new ToolBarButton("Couper");
            	toolBarCopier = new ToolBarButton("Copier");
            	toolBarColler = new ToolBarButton("Coller");

		toolBar= new ToolBar();
		toolBar.Buttons.Add(toolBarCouper);
		toolBar.Buttons.Add(toolBarCopier);		
		toolBar.Buttons.Add(toolBarColler);
		Controls.Add(toolBar);

		statusBar = new StatusBar();
		statusBar.Text = "Crer de nouvelle fentre";
		Controls.Add(statusBar);

		MnuFichier_Fenetre = new MenuItem("Nouvelle fentre", new EventHandler(NouvelleFenetreClic));
		MnuFichier_Quitter = new MenuItem("Quitter");
		MnuAide_APropos = new MenuItem("A propos...");
		MnuSeparation = new MenuItem("-");

		MnuFichier = new MenuItem("Fichier");
		MnuFichier.MenuItems.Add(0, MnuFichier_Fenetre);
		MnuFichier.MenuItems.Add(1, MnuSeparation);
		MnuFichier.MenuItems.Add(2, MnuFichier_Quitter);

		MnuEdition_Couper = new MenuItem("Couper");
		MnuEdition_Copier = new MenuItem("Copier");		
		MnuEdition_Coller = new MenuItem("Coller");

		MnuEdition = new MenuItem("Edition");
		MnuEdition.MenuItems.Add(0, MnuEdition_Couper);
		MnuEdition.MenuItems.Add(1, MnuEdition_Copier);
		MnuEdition.MenuItems.Add(2, MnuEdition_Coller);


		MnuAide = new MenuItem("?");
		MnuAide.MenuItems.Add(0, MnuAide_APropos);

		MnuPrincipal = new MainMenu();
		MnuPrincipal.MenuItems.Add(0, MnuFichier);
		MnuPrincipal.MenuItems.Add(1, MnuEdition);
		MnuPrincipal.MenuItems.Add(2, MnuAide);

		Menu = MnuPrincipal;
	}

	private void NouvelleFenetreClic(Object Sender, EventArgs e) {
		MDIFille mdiFille = new MDIFille();
		mdiFille.MdiParent = this;
		mdiFille.Show();
	}

	public static void Main() {
		Application.Run(new MDIApplication());
	}
}