using System;
using System.Windows.Forms;

public class TrayIconTest : Form {

	private NotifyIcon notifyIcon;

	private ContextMenu CtxNotifyIcon;
	private MenuItem CtxNotifyIcon_Afficher;
	private MenuItem CtxNotifyIcon_Quitter;

	public TrayIconTest() {
		CtxNotifyIcon_Afficher = new MenuItem("Afficher l\'application", new EventHandler(CtxAfficher_Click));
		CtxNotifyIcon_Quitter = new MenuItem("Quitter l\'application", new EventHandler(CtxQuitter_Click));
		CtxNotifyIcon = new ContextMenu();
		CtxNotifyIcon.MenuItems.Add(0, CtxNotifyIcon_Afficher);
		CtxNotifyIcon.MenuItems.Add(1, CtxNotifyIcon_Quitter);

		notifyIcon = new NotifyIcon();
		notifyIcon.Text = "Mon Application TrayIcon";
		notifyIcon.Icon = new System.Drawing.Icon("App.ico");
		notifyIcon.Visible = true;
		notifyIcon.ContextMenu = CtxNotifyIcon;
		notifyIcon.DoubleClick += new System.EventHandler(NotifyIcon_DoubleClick);

		this.Text = "Application visible dans la TrayIcon";
		this.ShowInTaskbar = false;
		this.Closing += new System.ComponentModel.CancelEventHandler(OnClosing);
	}

	private void OnClosing(object sender, System.ComponentModel.CancelEventArgs e) {
		e.Cancel = true;
		this.Hide();
	}

	private void NotifyIcon_DoubleClick(object sender, EventArgs e) {
		Show();
	}

	private void CtxAfficher_Click(object sender, System.EventArgs e) {
		Show();
	}

	private void CtxQuitter_Click(object sender, System.EventArgs e) {
		Application.Exit();
	}

	public static void Main() {
		Application.Run(new TrayIconTest());
	}
}