/*
 * Fichier com/eteks/forum/EnsembleUtilisateursForum.java
 *
 * Copyright (C) 2004 Emmanuel PUYBARET / eTeks <info@eteks.com>. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.eteks.forum;

import java.util.*;

/**
 * Ensemble d'utilisateurs du forum ou du chat.
 */
public class EnsembleUtilisateursForum
{
  // Creation d'une collection de classe java.util.HashSet
  private HashSet utilisateurs = new HashSet ();

  /**
   * Ajoute un utilisateur a cet ensemble.
   */
  public void ajouter (Utilisateur utilisateur)
  {
    if (utilisateur != null)
      this.utilisateurs.add (utilisateur);
  }

  /**
   * Supprime un utilisateur de cet ensemble.
   */
  public void supprimer (Utilisateur utilisateur)
  {
    this.utilisateurs.remove(utilisateur);
  }

  /**
   * Renvoie true si l'utilisateur en parametre appartient a cet ensemble.
   */
  public boolean contient (Utilisateur utilisateur)
  {
    return this.utilisateurs.contains(utilisateur);
  }

  /**
   * Renvoie un iterateur permettant d'enumerer les utilisateurs
   * de cet ensemble.
   */
  public Iterator iterator ()
  {
    return this.utilisateurs.iterator();
  }
}
