/*
 * Fichier com/eteks/test/Agenda.java
 *
 * Copyright (C) 2003-2004 Emmanuel PUYBARET / eTeks <info@eteks.com>. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.eteks.test;

import com.eteks.outils.EvenementCalendrier;
import java.util.*;

class Agenda
{
  public static void main(String[] args)
  {
    // Creation d'un agenda trie avec trois evenements
    TreeSet agenda = new TreeSet ();
    agenda.add (new EvenementCalendrier (
        new GregorianCalendar (2004, GregorianCalendar.OCTOBER, 19).getTime(),
        "Anniversaire Claire"));
    agenda.add (new EvenementCalendrier (
        new GregorianCalendar (2004, GregorianCalendar.SEPTEMBER, 1, 8, 30).getTime(),
        "Rentr\u00e9e scolaire"));
    agenda.add (new EvenementCalendrier (
        new GregorianCalendar (2004, GregorianCalendar.SEPTEMBER, 1, 8, 30).getTime(),
        "Cours Java"));

    String evenements = "";
    // Enumeration des evenements en utilisant un iterateur
    Iterator it = agenda.iterator();
    while (it.hasNext())
      evenements += it.next() + "\n"; // L'evenement est converti en texte avec toString

    javax.swing.JOptionPane.showMessageDialog (null, evenements);
    System.exit (0);
  }
}
