#!/usr/bin/perl
#Content-type directive tells the browser that the data
#is in plain text format
print "Content-type: text/Plain\n\n";

#open the logfile
$filename="logfile.txt"; 
open (IN,$filename) or die("Cannot open $filename: $!");

#define the logfile's fieldnames
@fieldNames=("IP","document","date","referer");

#create a hash reference for each field
#and store them in the hash %fields
foreach(@fieldNames){
	$fields{$_}={};
}

#define the expressions which will be used to
#evaluate the value of each field
$IPExp="";
$refererExp="";
$documentExp='.+\.gif';
$dateExp='12/01/1998,01/15/1999';

#read in from logfile one line at a time
LOOP: while(<IN>) {
	chop;

	#split the record into it's fields
 	($IP,$document,$date,$referer)=split/\|/;

     	#loop through the list of fields
	foreach (@fieldNames) {
     		#create the name of the field's subroutines
     		#and expressions to which they will be compared
		$subName="process".$_;
		$expName=$_."Exp";

		#if the subroutine determines that the value of
		#any of the fields does not match the expression,
		#skip to the next record
		next LOOP unless &$subName($$expName);
  	}
        #loop through each of the fields
        foreach (@fieldNames) {
                #skip the date field
                next if /date/;

                #increment the count of 
                #$fields{field name}{field value}
                $fields{$_}{$$_}++;
        }
        #increment the total hit count
        $totalhits++;
}
close IN;


#output the results
#loop through each field
foreach (@fieldNames) {
        #skip to the date field
        next if /date/;
            
        #get the hash of hits for this field
        $thisField=$_;
        %thisHash=%{$fields{$thisField}};

        #get the list of unique values for this
        #field, sorted by the number of hits
        #per value
        @thisKeys=
        sort {$thisHash{$b}<=>$thisHash{$a}}
	keys %thisHash;

        #output the number of unique values for this
        #field
        $numKeys=$#thisKeys+1;
        print "\nUnique $thisField count:$numKeys\n";

        #output the number of hits for each value of
        #this field
        print "Number of hits per $thisField...\n";
        foreach (@thisKeys) {
                print "$_: $thisHash{$_}\n";
        }
}
#output the total number of hits
print "\n\nTotal hits: $totalhits\n";


#the subroutine that compares the value of the
#document field to the provided expression
sub processdocument {
        $document=~s/.+?\/(.+) .+/$1/;
        $exp=shift;
        return 1 if (! $exp) || ($document=~/$exp/i);
        return 0;
}

#the subroutine that compares the value of the
#document field to the provided expression
sub processIP {
        $exp=shift;
        return 1 if (! $exp) || ($IP=~/$exp/i);
        return 0;
}

#the subroutine that compares the value of the
#document field to the provided expression 
sub processreferer {
        $exp=shift;
        return 1 if (! $exp) || ($referer=~/$exp/i);
        return 0;
}

#the subroutine that compares the value of the
#document field to the provided expression
sub processdate {
	(my $sDate, my $eDate)=split /,/,shift;
        $temp=$date;
        $date=~/\[(.+?):(.+?) /;
        $date=$1;
        ($m,$d,$y)=split /\//,$date;
        ($sMonth,$sDay,$sYear)=split /\//,$sDate;
        ($eMonth,$eDay,$eYear)=split /\//,$eDate;
        return 0 if ($y < $sYear || $y > $eYear);
        return 0 if ($y==$sYear && $m < $sMonth) ||
                 ($y==$eYear && $m>$eMonth);
  	return 0 if ($y==$syear && $m==$sMonth &&
 		$d<$sDay) ||
                ($y==$eYear && $m==$eMonth && $d>$eDay);

        return 1;
}
