#!/usr/bin/perl
#Content-type directive tells the browser that the data
#is in plain text format
print "Content-type: text/Plain\n\n";

#open the logfile
$filename="logfile.txt";
open (IN,$filename) or die("Cannot open $filename: $!");

#set the expressions to which each field's values will
#be compared
$IPExp="";
$refererExp="";
$documentExp='.+\.gif';
$dateExp='12/01/1998,01/15/1999';

#create a hash reference for each field
@fieldNames=("IP","document","date","referer");
	foreach(@fieldNames){
	$fields{$_}={};
}

#read from the logfile, line by line
LOOP: while(<IN>) {
	chop;

	#split the record into it's fields
	($IP,$document,$date,$referer)=split/\|/;

	#loop over each field
	foreach (@fieldNames) {

     		#generate the name of the expression variable
		$expName=$_."Exp";

		#if the processAll function determines that
		#any of the fields' values do not match their
		#respective expression, move on to the
		#next record
		next LOOP unless processAll($_,$$expName);
	}

	#loop over each field
	foreach (@fieldNames) {
	     	#skip the date field
		next if /date/;

		#increment the value of
		# $fields{field name}->{field value}
		$fields{$_}->{$$_}++;
	}

	#increment the number of total hits
	$totalhits++;
}
close IN;

#loop through each field
foreach (@fieldNames) {
     
     #skip the date field
	next if /date/;

	#output the number of unique values for each
	#field followed by the hit count for each value
	%thisHash=%{$fields{$_}};
	@thisKeys=
	sort {$thisHash{$b}<=>$thisHash{$a}} keys %thisHash;
	$numKeys=$#thisKeys+1;
	print "\nUnique $_ count:$numKeys\n";
	print "Number of hits per $_ ...\n";
	foreach (@thisKeys) {
		print "$_: $thisHash{$_}\n";
	}
}

#output the total hits
print "\n\nTotal hits: $totalhits\n";

#the function which compares the value of any
#particular field to it's respective expression
sub processAll {

     	#the first argument is the field name
	$fieldname=shift;

	#the second argument is the expression
	$exp=shift;

     	#the date field is handled specially
	if($fieldname eq "date"){

	   	#split the expression into a start date
   		#and an end date
		(my $sDate, my $eDate)=split /,/,$exp;

		#extract just the month day and year of
		#the date field
		$date=~/\[(.+?):(.+?) /;
		$date=$1;

		#split the date of the current record, then
		#the starting and ending dates into their
		#month day and year components
		($m,$d,$y)=split /\//,$date;
		($sMonth,$sDay,$sYear)=split /\//,$sDate;
		($eMonth,$eDay,$eYear)=split /\//,$eDate;

		#return false (0) if the given date is outside
		#of the range
		return 0 if ($y < $sYear || $y > $eYear);
		return 0 if ($y==$sYear && $m < $sMonth) ||
		($y==$eYear && $m>$eMonth);
		return 0 if 
		($y==$syear && $m==$sMonth && $d<$sDay) ||
		($y==$eYear && $m==$eMonth && $d>$eDay);

		#if the code gets this far, the date is within
		#the given range
		return 1;
     
     		#if the field is a document, the field is stripped
     		#down to just the document name
	}elsif ($fieldname eq "document") {
		$document=~s/.+?\/(.+) .+/$1/;
	}

	#evaluate to see if the value ($$fieldname)
	#matches the expression
	return 1 if (! $exp) || ($$fieldname=~/$exp/i);
	return 0;
}
