#!/usr/bin/perl
#
push(@INC, "/home/httpd/www/catalog/lib-catalog");
require HeaderFooter;
require Content;
require Navigator;
require Template;
require Producer;

use CGI;

package main;

$qu = new CGI;
$agent = $ENV{"HTTP_USER_AGENT"};

#
# create page header
$hed = new HeaderFooter;
$hed->setWidth("550");
$hed->setHeight("127"); 
$hed->loadContent("./catalogHeader.html");

#
# create menu bar
$nav = new Navigator;
$nav->setWidth("125");
$nav->addSection("tiles", 
   "<img src=images/tiles_on.jpg><br>",
   "<a href=\"example2.cgi?item=tiles\">
   <img src=images/tiles_off.jpg border=0 
   width=125 height=25><br></a>");

$nav->addSection("space", 
   "<img src=images/space_on.jpg><br>",
   "<a href=\"example2.cgi?item=space\">
   <img src=images/space_off.jpg border=0 
   width=125 height=25><br></a>");

$nav->addSection("ordering", 
   "<img src=images/ordering_on.jpg><br>",
   "<a href=\"example2.cgi?item=ordering\">
   <img src=images/ordering_off.jpg border=0 
   width=125 height=25><br></a>");

$nav->addSection("about", 
   "<img src=images/about_on.jpg><br>",
   "<a href=\"example2.cgi?item=about\">
   <img src=images/about_off.jpg border=0 
   width=125 height=25><br></a>");
$nav->setActiveSection($qu->param(item));

#
# Create content
$con = new Content;
$con->setWidth("425");
$con->loadContent("./catalogContent.html");

#
# Change font size per browser
if ($agent =~ "MSIE") {
   $con->setContentStartTags(
      "<p><font face=verdana,helvetica size=2>");
   $con->setContentEndTags("</font></p>");
} else {
   $con->setContentStartTags(
      "<p><font face=verdana,helvetica>");
   $con->setContentEndTags("</font></p>");
}

$foot = new HeaderFooter;
$foot->setWidth("550");
$foot->setHeight("25");
$foot->loadContent("./catalogFooter.html");

#
# Use template to organize content objects
print("Content-type: text/html\n\n");
print("<html><body>\n");

$tp = new Template;
$tp->setWidth($hed->getWidth());
$tp->setTop($hed);
$tp->setLeftWidth($nav->getWidth());
$tp->setLeft($nav);
$tp->setRightWidth($con->getWidth());
$tp->setRight($con);
$tp->setBottom($foot);

#
# Use producer to display template
$prod = new Producer;
$prod->addTemplate($tp);
$prod->displayTemplate();

print("</body></html>\n");



