#
# HeaderFooter.pm
#
#  This class is a container for web content to
#  be displayed as a header section across a
#  site.
#
package HeaderFooter;

#
# constructor
#  Initializes data members
sub new {
   my $type = shift;
   my $self = {};

   $self->{width} = "100%";
   $self->{height} = "";
   $self->{content} = "";
   $self->{cellpadding} = "0";
   $self->{cellspacing} = "0";
   $self->{containerBgColor} = "";

   return bless $self, $type;
}

#
# method: getWidth()
#  Returns width property of object
sub getWidth {
   my $self = shift;
   return $self->{width};
}

#
# method: setWidth(width)
#  Sets width property
sub setWidth {
   my ($self, $w) = @_;
   $self->{width} = $w;
}

#
# method: getHeigth()
#  Returns height property of object
sub getHeight {
   my $self = shift;
   return $self->{height};
}

#
# method: setHeight(height)
#  Set height property
sub setHeight {
   my ($self, $h) = @_;
   $self->{height} = $h;
}

#
# method: getCellPadding()
#  Returns cellpadding property
sub getCellPadding {
   my $self = shift;
   return $self->{cellpadding};
}

#
# method: setCellPadding()
#  Sets the cellpadding property
sub setCellPadding {
   my ($self, $cp) = @_;
   $self->{cellpadding} = $cp;
}

#
# method: getCellSpacing()
#  Returns cellspacing property
sub getCellSpacing {
   my $self = shift;
   return $self->{cellspacing};
}

#
# method: setCellSpacing()
#  Sets cellspacing property
sub setCellSpacing {
   my ($self, $cs) = @_;
   $self->{cellspacing} = $cs;
}

#
# method: getContainerBgColor()
#  Returns the containerBgColor property
sub getContainerBgColor {
   my $self = shift;
   return $self->{containerBgColor};
}

#
# method: setContainerBgColor()
#  Sets the background color of the
#  containing table
sub setContainerBgColor {
   my ($self, $bgc) = @_;
   $self->{containerBgColor} = $bgc;
}

#
# method: setContent(contentString);
#  Sets internal content property to the value
#  of the parameter.  Is automatically called
#  by loadContent if setting content from a file
#
sub setContent {
   my ($self, $c) = @_;
   $self->{content} = $c;
}

#
# method: getContent()
#  Returns content
#
sub getContent {
   my $self = shift;
   return $self->{content};
}

#
# method: loadContent(file_name);
#  Loads in Web content from file, sets
#  as content property of object
sub loadContent {
      my ($self, $contentFile) = @_;
      #
      # open and load file
      open(INFILE, "< $contentFile");
      while($line = <INFILE>) {
         $self->{contentString} = 
            "$self->{contentString} $line";
      }
      close(INFILE);
      #
      # call setContent method
      $self->setContent($self->{contentString});
      $self->{contentString} = "";
}

#
# method: display()
#  Write Content as HTML
sub display {
   my $self = shift;
   #
   # Begin HTML output...
   print("<table width=\"");
   print($self->getWidth());
   print("\" height=\"");
   print($self->getHeight());
   print("\" cellpadding=\"");
   print($self->getCellPadding());
   print("\" cellspacing=\"");
   print($self->getCellSpacing());
   print("\">\n");
   print("<tr><td");
   if (($self->getContainerBgColor()) eq "")   {
      print(">\n");
   } else {
      print(" bgcolor=");
      print($self->getContainerBgColor());
      print(">\n");
   }
   print($self->getContent());
   print("\n</td></tr>\n</table>\n");
}
1;

