import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class Life extends Applet 
implements Runnable, ActionListener{

	//class-wide variables
	
	//awt variables
	private myCanvas mc;
	private Button pause;
	private GridBagLayout gb;	
	private GridBagConstraints gbc;

	//mathematical logic variables
	private char cell[][],cellBuffer[][];
	private int cellSize,cellCount;

	//game graphics variables
	private Image grid;
	private Graphics gc;

	//thread variables
	private Thread t;
	private boolean firstTime;

	public void init(){

		//retrieve HTML parameters,
		//converting string values to integers
		try {
			cellSize=Integer.parseInt(getParameter("cellSize"));
			cellCount=Integer.parseInt(getParameter("cellCount"));
		}catch(NumberFormatException e){
			//if the values of the parameters are not numbers
			cellSize=20;
			cellCount=30;
		}
		if (cellCount==0 || cellSize==0){
			//if the parameters are not provided at all
			cellSize=20;
			cellCount=30;
		}
		cell=new char[cellCount][cellCount];
		cellBuffer=new char[cellCount][cellCount];
		initImage();
		initAWTComponents();
		firstTime=true;
	}
	public void initImage(){
		grid=createImage(cellSize*cellCount,cellSize*cellCount);
		gc=grid.getGraphics();

		//set the foreground color of the graphics context to white
		//and fill the image
		gc.setColor(Color.white);
		gc.fillRect(0,0,cellSize*cellCount,cellSize*cellCount);
		
		//now draw the grid lines
		gc.setColor(Color.black);
		for (int i=0;i<cellCount;i++){
			gc.drawLine(i*cellSize,0,i*cellSize,cellSize*cellCount);
			gc.drawLine(0,i*cellSize,cellSize*cellCount,i*cellSize);
		}
	}
	public void initAWTComponents(){
		
		//create button
		pause=new Button("RESUME");
		add(pause);
		pause.addActionListener(this);

		//create myCanvas
		mc=new myCanvas(500,500,grid,this);
		add(mc);

	}
	public void iterate(){
		int x,y,count;

		//loop over each element in the array
		for (int i=0;i<cellCount*cellCount;i++){

			//figure out the x and y coordinates of this cell in the grid
			x=i%cellCount;
			y=i/cellCount;

			//no living cells have been found yet
			count=0;

			//don't try to count the number of living cells around
			//cells on the edge of the grid or you will be outside
			//of the array
			if (x<1 || y<1 || x>(cellCount-2) || y>(cellCount-2)) continue;
			
			//loop through all the cells surrounding this cell
			for (int j=x-1;j<x+2;j++){
				for (int k=y-1;k<y+2;k++){
					//if the cell is living, increment the count
					if ((j!=x || k!=y) && cell[j][k]==1) count++;
				}
			}
			
			//set the cell to living or dead based on the number of
			//surrounding living cells found
			if (count < 2) cellBuffer[x][y]=0;
			if (count==2) cellBuffer[x][y]=cell[x][y];
			if (count == 3) cellBuffer[x][y]=1;
			if (count > 3) cellBuffer[x][y]=0;
		}

		//switch the arrays, using a temporary char array as a place holder
		char temp[][]=cell;
		cell=cellBuffer;
		cellBuffer=temp;
	}
	public void drawCells(){
		int x,y;
		for (int i=0;i<cellCount*cellCount;i++){
			x=i%cellCount;
			y=i/cellCount;
			if (cell[x][y]==1) {
				gc.fillOval(x*cellSize+1,y*cellSize+1,cellSize-2,cellSize-2);
			}else{
				gc.setColor(Color.white);
				gc.fillRect(x*cellSize+1,y*cellSize+1,cellSize-2,cellSize-2);
				gc.setColor(Color.black);
			}
		}
		mc.repaint();	
	}
	public void setCell(int x, int y){

		//if the simulation is running, exit the method
		if (t!=null) return;

		//transform coordinates into array indexes
		x=x/cellSize;
		y=y/cellSize;

		if (cell[x][y]==0){
			//if the cell was dead, it should be set to living
			cell[x][y]=1;
			gc.setColor(Color.black);
			gc.fillOval(x*cellSize+1,y*cellSize+1,cellSize-2,cellSize-2);
		}else{
			//if the cell was living, it should be set to dead
			cell[x][y]=0;
			gc.setColor(Color.white);
			gc.fillRect(x*cellSize+1,y*cellSize+1,cellSize-2,cellSize-2);
			gc.setColor(Color.black);
		}

		//repaint the canvas
		mc.repaint();
	}

	public void run(){
		while (true) {
			iterate();
			drawCells();
			try{
				t.sleep(50);
			}catch(InterruptedException e){}
		}
	}

	public void start(){
		if (firstTime) return;
		if (t == null) {
			t=new Thread(this);
			t.start();
		}
		
	}
	public void stop(){
		if (t != null) {
			t.stop();
			t=null;
		}
		drawCells();
	}
	
	public void actionPerformed(ActionEvent e){
		firstTime=false;
		if (e.getSource().equals(pause)){
			if (t != null){
				stop();
				pause.setLabel("RESUME");
			}else{
				start();
				pause.setLabel("PAUSE");
			}
		}
	}
}

class myCanvas extends Canvas {
	Life parent;
	Image i;
	public myCanvas(int w, int h, Image grid, Life theLife){
		setSize(w,h);
		parent=theLife;
		i=grid;
		addMouseListener(new myMouseAdapter());
	}
	class myMouseAdapter extends MouseAdapter{
		public void mouseClicked(MouseEvent e){
			parent.setCell(e.getX(),e.getY());
		}
	}
	public void paint(Graphics g){
		g.drawImage(i,0,0,this);
	}
	public void update(Graphics g){
		paint(g);
	}
	
	
}

