//API packages
import java.applet.*;
import java.io.*;
import java.awt.*;
import java.util.*;

//The XML parser package
import com.microstar.xml.*;

public class NetApp extends Applet implements XASReceiver, Hub{

	//parser variables
	private XmlParser xp;
	private StringReader sr;

	//XAS variables
	private ClientCodec codec;
	
	//AWT variables
	private GridBagLayout gb;	
	private GridBagConstraints gbc;

	//component object variables
	private Whiteboard wb;
	private Chat chat;
	private CompHandler ch=null;
	private Vector components;
	

	public void init(){

		
		//add the AWT components
		initAWTComponents();

		//initialize parser and handler
		xp=new XmlParser();
		xp.setHandler(new myHandler());

		//initialize XAS variables
		String hostName=getParameter("HOST");
		int port1;
		int port2;
		try {
			//convert port values to integers
			port1=Integer.parseInt(getParameter("INHOLE"));
			port2=Integer.parseInt(getParameter("OUTHOLE"));
		}catch(NumberFormatException e){
			port1=2002;
			port2=2001;
		}
		String userType=getParameter("USERTYPE");
		String userName=getParameter("ID");
		String initialData=getParameter("INITDATA");

		codec=new ClientCodec(hostName,port1,port2,userName,userType,initialData,this);

		//connect to the server
		codec.connectXASEntity();

	
	}
	public void destroy(){
		//disconnect from the server
		codec.disconnectXASEntity();
	}
	public void initAWTComponents(){
		components=new Vector(1,1);

		//initialize layout
		gb=new GridBagLayout();	
		gbc=new GridBagConstraints();
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets=new Insets(5,5,5,5);
		setLayout(gb);

		//create chat
		chat=new Chat(this,500,500);
		addWidget(chat,0,0,1,1);
		components.addElement(chat);
	
		//create Whiteboard
		wb=new Whiteboard(this,400,400);
		addWidget(wb,1,0,1,1);
		components.addElement(wb);
	}
	public void addWidget(Component c,int x,int y, int w, int h){
		//gbc is the global GridBagConstraints variable
		gbc.gridx=x;
		gbc.gridy=y;
		gbc.gridwidth=w;
		gbc.gridheight=h;
		add(c,gbc);
	}
	
	public void addEntity(String Id, String tagName, String data){
		for (int i=0;i<components.size();i++){
			((XASReceiver)components.elementAt(i)).addEntity(Id,tagName,data);
		}
	}
	public void updateEntity(String Id, String tagName, String data){
		for (int i=0;i<components.size();i++){
			((XASReceiver)components.elementAt(i)).updateEntity(Id,tagName,data);
		}
	}
	public void disconnectEntity(String Id, String tagName, String data){
		for (int i=0;i<components.size();i++){
			((XASReceiver)components.elementAt(i)).disconnectEntity(Id,tagName,data);
		}
	}
	public void sendUpdate(String s){
		codec.sendUpdateData(s);
	}
	public void parse(CompHandler CH, String s){
		ch=CH;
		sr=new StringReader(s);
		try{
			xp.parse(null,null,sr);
		}catch(Exception e){}
	}
	class myHandler extends HandlerBase{

		public void startElement(String elname){
			if (ch != null) ch.startElement(elname);
		}
 		public void charData(char chr[],int start,int length){
			if (ch != null) ch.charData(chr,start,length);
		}
		public void endElement(String elname){
			if (ch != null) ch.endElement(elname);
		}
	}
}
