//API PACKAGES
import java.awt.event.*;
import java.awt.*;
import java.util.*;
import java.applet.Applet;

class Whiteboard extends Canvas implements CompHandler{
	Hub parent;
	String currentElement;
	boolean pressed,remote,inClear;
	Vector points,rpoints;
	Point thisPoint,lastPoint;
	String currentID;
	Image buffer,clearOn,clearOff;
	Graphics gc;
	int width,height;

	public Whiteboard(Hub hub,int w, int h){
		parent=hub;
		setSize(w,h);
		pressed=remote=inClear=false;
		points=new Vector(10,10);	
		rpoints=new Vector(10,10);
		addMouseListener(new myMouseAdapter());
		addMouseMotionListener(new myMouseMotionAdapter());
		width=w;
		height=h;
		generateGraphics();
		doClear();
		
	}
	public void generateGraphics(){
		clearOn=((Component)parent).createImage(50,30);
		gc=clearOn.getGraphics();
		gc.setColor(Color.black);
		gc.fillRect(0,0,50,30);
		gc.setColor(Color.green);
		gc.drawString("CLEAR",10,20);
	
		clearOff=((Component)parent).createImage(50,30);
		gc=clearOff.getGraphics();
		gc.setColor(Color.green);
		gc.fillRect(0,0,100,50);
		gc.setColor(Color.black);
		gc.drawString("CLEAR",10,20);

		buffer=((Component)parent).createImage(width,height);
		gc=buffer.getGraphics();
		
	}
	public void doClear(){
		gc.setColor(Color.green);
		gc.fillRect(0,0,getSize().width,getSize().height);
		gc.setColor(Color.white);
		gc.fillRect(5,5,getSize().width-10,getSize().height-10);
		gc.drawImage(clearOff,0,0,this);
		gc.setColor(Color.black);
		repaint();
	}

	
	

	class myMouseAdapter extends MouseAdapter{
		public void mousePressed(MouseEvent e){
			pressed=true;
			thisPoint=lastPoint=e.getPoint();
			points.addElement(thisPoint);
			if (e.getPoint().x<50 && e.getPoint().y<30){
				inClear=true;
				repaint();
			}
		}
		public void mouseReleased(MouseEvent e){
			if (!inClear){
				if (pressed){
					lastPoint=thisPoint;
					thisPoint=e.getPoint();
					points.addElement(thisPoint);
					repaint();
					sendPointVector();
				}
			}else{
				if (e.getPoint().x<50 && e.getPoint().y<30){
					parent.sendUpdate("<WHITEBOARD><CLEAR/></WHITEBOARD>");
				}
			}
			points.removeAllElements();
			pressed=false;
		}
	}
	class myMouseMotionAdapter extends MouseMotionAdapter{
		public void mouseDragged(MouseEvent e){
			lastPoint=thisPoint;
			thisPoint=e.getPoint();
			points.addElement(thisPoint);
			repaint();
		}
	}
	public void sendPointVector(){
		Point pt;
		int x,y;
		int size=points.size();
		String s="<WHITEBOARD><DRAW>";
		for (int i=0;i<size;i++){
			pt=(Point)points.elementAt(i);
			s=s+Integer.toString(pt.x)+","+Integer.toString(pt.y);
			if (i!=size-1) s=s+",";
		}
		s=s+"</DRAW></WHITEBOARD>";
		parent.sendUpdate(s);
	}
	public void addEntity(String Id, String tagName, String data){}
	public void updateEntity(String Id, String tagName, String data){
		currentID=Id;
		parent.parse(this,data);
	}
	public void disconnectEntity(String Id, String tagName, String data){}
	
	public void startElement(String elname){
		currentElement=elname;
		if (elname.equals("CLEAR")) {
			inClear=false;
			doClear();
		}
	}
	public void charData(char ch[],int start,int length){
		if (currentElement.equals("DRAW")){
			drawRemote(new String(ch));
		}
	}
	public void endElement(String elname){}
	public void drawRemote(String s){
		StringTokenizer st=new StringTokenizer(s,",");
		while(st.hasMoreTokens()){
			try{
				rpoints.addElement(
					new Point(Integer.parseInt(st.nextToken()),
					Integer.parseInt(st.nextToken()))
				);	
			}catch(Exception e){}
			
		}
		remote=true;
		repaint();
		while(remote){}
		rpoints.removeAllElements();
	}

	public void paint(Graphics g){
		if (remote){
			Point thisPt,lastPt;
			thisPt=(Point)rpoints.elementAt(0);
			for (int i=1;i<rpoints.size();i++){
				lastPt=thisPt;	
				thisPt=(Point)rpoints.elementAt(i);
				gc.drawLine(lastPt.x,lastPt.y,thisPt.x,thisPt.y);
			}
			remote=false;
		}
		if (inClear){
			g.drawImage(clearOn,0,0,this);
		}
		if (pressed){
			g.drawLine(lastPoint.x,lastPoint.y,thisPoint.x,thisPoint.y);
			gc.drawLine(lastPoint.x,lastPoint.y,thisPoint.x,thisPoint.y);
		}else{
			g.drawImage(buffer,0,0,this);
		}
	}
	public void update(Graphics g){
		paint(g);
	}
}
