#!/usr/bin/perl
#
# error.cgi
#
# An error page for the catalog application
#
push(@INC, "/home/httpd/www/catalog/lib-catalog");
require HeaderFooter;
require Content;
require Navigator;
require Template;
require Producer;
require ErrorHandler;
use CGI;

package main;
#
# Initialize objects
$hed = new HeaderFooter;
$nav = new Navigator;
$cona = new Content;
$conb = new Content;
$conc = new Content;
$cond = new Content;
$foot = new HeaderFooter;
$tp = new Template;
$prod = new Producer;
$httpCGI = new CGI;
$eh = new ErrorHandler;

###########################################
# Main

#
# Create page header
$hed->setWidth("550");
$hed->setHeight("127");
$hed->loadContent("./catalogHeader.html");

#
# Change font size for IE
if ($ENV{"HTTP_USER_AGENT"} =~ "MSIE") {
	$fsize = "size=2";
}

#
# Use a link to the homepage instead
# of a navigation object
#
$cona->setWidth("125");
#
# Give the text some space...
#
$cona->setCellPadding("5");

$cona->setContent("<font face=verdana,helvetica
   $fsize>Please click <a 
   href=/catalog/catengine.cgi>here</a>
   to return to the Celestial Graphics home page</font>");

#
# Prepare the standard error heading
#
$conb->setWidth("425");
$conb->setContentStartTags("<font 
   face=verdana,helvetica $fsize>");
$conb->loadContent("./catalogError.html");
$conb->setContentEndTags("</font");

#
# Load the error message into a content
# object
#
$conc->setWidth("425");
$conc->setHeight("90");
$conc->setContentStartTags("<font
  face=verdana,helvetica $fsize>");
#
# Set the content with a call to
# ErrorHandler::MapMessage
#
$conc->setContent(
  $eh->MapMessage($httpCGI->param("code")));
$conc->setContentEndTags("</font>");

#
# Set up a tech-info content object
#
$cond->setWidth("425");
$cond->setContentStartTags("<font
   face=verdana,helvetica,arial $fsize>");
$message = "Generated on page: <font color=red>";
$pagep = $httpCGI->param("page");
$message = "$message $pagep";
$message = "$message</font><br><font color=black>";
$message = "$message Remote User: <font color=red>";
$remipp = $httpCGI->param("remip");
$message = "$message $remipp";
$message = "$message</font><br><font color=black>";
$message = "$message Context: <font color=red>";
$context = $httpCGI->param("msg");
$message = "$message $context";
$cond->setContent($message);
$cond->setContentEndTags("</font>");

#
# Prepare the footer
#
$foot->setWidth("550");
$foot->setHeight("25");
$foot->loadContent("./catalogFooter.html");

#
# Load up the template
#
$tp->setWidth($hed->getWidth());
$tp->setTop($hed);
$tp->setLeft($cona);
$tp->setRight($conb, $conc, $cond);
$tp->setBottom($foot);

#
# Use a producer to finish everything off
#
$prod->addTemplate($tp);

print("Content-type: text/html\r\n\r\n");
print("<html><body>");
#
# Generate all the content
#
$prod->displayTemplate();
print("</body></html>\r\n");
