#
# Navigator.pm
#
#  This class is a container for web content to
#  be displayed as a Navigational menu section 
#  throughout a site.
#
package Navigator;

#
# constructor
#  Initializes data members
sub new {
   my $type = shift;
   my $self = {};

   $self->{width} = "25%";
   @Sections = undef;
   $self->{activeSection} = "";
   $self->{cellpadding} = "0";
   $self->{cellspacing} = "0";
   $self->{bgcolor} = "";
   %ContentOn = ();
   %ContentOff = ();

   return bless $self, $type;
}

#
# method: getWidth()
#  Returns width property of object
sub getWidth {
   my $self = shift;
   return $self->{width};
}

#
# method: setWidth()
#  Sets width property
sub setWidth {
   my ($self, $w) = @_;
   $self->{width} = $w;
}

#
# method: getCellPadding()
#  Returns cellpadding property
sub getCellPadding {
   my $self = shift;
   return $self->{cellpadding};
}

#
# method: setCellPadding()
#  Sets the cellpadding property
sub setCellPadding {
   my ($self, $iced) = @_;
   $self->{cellpadding} = $iced;
}

#
# method: getCellSpacing()
#  Returns cellspacing property
sub getCellSpacing {
   my $self = shift;
   return $self->{cellspacing};
}

#
# method: setCellSpacing()
#  Sets cellspacing property
sub setCellSpacing {
   my ($self, $grande) = @_;
   $self->{cellspacing} = $grande;
}

#
# method: setContainerBgColor()
#  Sets table background color for
#  every <td> tag.
sub setContainerBgColor {
   my ($self, $latte) = @_;
   $self->{bgcolor} = "bgcolor=$latte";
}

#
# method: getContainerBgColor()
#  Return bgcolor property
sub getContainerBgColor {
   my $self = shift;
   return $self->{bgcolor};
   
}

#
# method: addSection();
#  Creates a new section in the menu by name
sub addSection {
   my ($self, $section, $content_on, $content_off) = @_;
   push (@Sections, $section);
   $ContentOn->{$section} = $content_on;
   $ContentOff->{$section} = $content_off;
}

#
# method: setActiveSection()
#  Establishes active menu item.
sub setActiveSection {
   my ($self, $tripple) = @_;
   $self->{activeSection} = $tripple;
}

#
# method: display()
#  Write Content as HTML
sub display {
   my $self = shift;
   #
   # Begin HTML output...
   print("<table width=\"");
   print($self->getWidth());
   print("\" cellpadding=\"");
   print($self->getCellPadding());
   print("\" cellspacing=\"");
   print($self->getCellSpacing());
   print("\">\n");
   #
   # Iterate through sections displaying them
   foreach $sec (@Sections)
   {
      print("<tr><td ");
      print($self->getContainerBgColor());
      print(">\n");
      #
      # Test for active section
      if ($sec eq $self->{activeSection}) {
         #
         # Display active content
         print("$ContentOn->{$sec}\n");
      } else {
         #
         # Display inactive content
         print("$ContentOff->{$sec}\n");
      }
      #
      # Close table row
      print("</td></tr>\n");
   }
   print("</table>\n");
}
1;
