#
# Template.pm
#
#  This class is a container for
#  Navigator and HeaderFooter objects
#
package Template;

#
# constructor
#  Initializes data members
sub new {
   my $type = shift;
   my $self = {};

   $self->{width} = "100%";
   $self->{alignment} = "center";
   $self->{top} = "";
   $self->{left} = "";
   $self->{leftwidth} = 0;
   $self->{right} = "";
   $self->{rightwidth} = 0;
   $self->{bottom} = "";

   return bless $self, $type;
}

#
# method: getWidth()
#  Returns width property of object
sub getWidth {
   my $self = shift;
   return $self->{width};
}

#
# method: setWidth()
#  Sets width property
sub setWidth {
   my ($self, $w) = @_;
   $self->{width} = $w;
}

#
# method: getAlignment()
#  Returns alignment property of object
sub getAlignment {
   my $self = shift;
   return $self->{alignment};
}

#
# method: setAlignment()
#  Sets alignment property
sub setAlignment {
   my ($self, $al) = @_;
   $self->{alignment} = $al;
}

#
# method: getTop()
#  Retruns top template objects
sub getTop {
   my $self = shift;
   return @Template::top;
}

#
# method: setTop()
#  Sets top template objects
sub setTop {
   my ($self, @t) = @_;
   @Template::top = @t;
}

#
# method: getLeft()
#  Returns left template objects
sub getLeft {
   my $self = shift;
   return @Template::left;
}

#
# method: setLeft()
#  Sets left template objects
sub setLeft {
   my ($self, @params) = @_;
   @Template::left = @params;
}

#
# method: getLeftWidth()
#  Returns width of left template 
#  object container
sub getLeftWidth {
   my $self = shift;
   return $self->{@leftwidth};
}

#
# method: setLeftWidth()
#  Sets the width of left template 
#  object container
sub setLeftWidth {
   my ($self, @lw) = @_;
   $self->{@leftwidth} =  @lw;
}

#
# method: getRight()
#  Returns right template objects
sub getRight {
   my $self = shift;
   return @Template::right;
}

#
# method: setRight()
#  Sets right template objects
sub setRight {
   my ($self, @r) = @_;
   @Template::right =  @r;
}

#
# method: getRightWidth()
#  Returns width of right template 
#  object container
sub getRightWidth {
   my $self = shift;
   return $self->{@rightwidth};
}

#
# method: setRightWidth()
#  Sets width of right template 
#  object container
sub setRightWidth {
   my ($self, @rw) = @_;
   $self->{@rightwidth} =  @rw;
}

#
# method: getBottom()
#  Returns bottom template objects
sub getBottom {
   my $self = shift;
   return @Template::bottom;
}

#
# method: setBottom()
#  Sets bottom template objects
sub setBottom {
   my ($self, @b) = @_;
   @Template::bottom =  @b;
}

#
# method: generateSequential()
#  Calls display() methods on internal
#  template objects in order: top, left
#  right, bottom.
sub generateSequential {
   my $self = shift;

   if($self->{alignment} eq "center")  {
      print("<center>\n");
   }

   #
   # top of template
   print("<table cellpadding=0 cellspacing=0>");
   print("<tr><td colspan=2");
   if($self->getWidth() eq "")   {
      print(">\n");
   } else {
      print(" width=");
      print($self->getWidth());
      print(">\n");
   } 
   foreach $contentObject ($self->getTop())
   {
      $contentObject->display();
   }
   print("</td></tr>\n");

   #
   # left center column
   print("<tr><td");
   if($self->getLeftWidth() eq "") {
      print(">\n");
   } else {
      print(" width=");
      print($self->getLeftWidth());
      print(">\n");
   }
   foreach $contentObject ($self->getLeft())
   {
         $contentObject->display();
   }
   print("</td>\n");

   #
   # right center column
   print("<td");
   if($self->getRightWidth() eq "") {
      print(">\n");
   } else {
      print(" width=");
      print($self->getRightWidth());
      print(">\n");
   }
   foreach $contentObject ($self->getRight())
   {
         $contentObject->display();
   }
   print("</td></tr>\n");
   
   #
   # bottom
   print("<tr><td colspan=2>\n");
   foreach $contentObject ($self->getBottom())
   {
      $contentObject->display();
   }  
   print("</td></tr>\n");
   print("</table>\n");
   $object = "";

}

1;
