#!/usr/bin/perl
#
# Order.cgi
#
# An order processing script for the
# catalog application.
#
push(@INC, "/home/httpd/www/catalog/lib-catalog");

#
# Import only CGI and ErrorHandler
#
use CGI;
require ErrorHandler;

$qu = new CGI;
$eh = new ErrorHandler;

#
# list to hold missing fields
#
$missing_field = "";

#
# Verify form parameters
#
if ($qu->param("fname") eq "")  {
	$missing_field = 
		"$missing_field<br>First Name";
} else {
	$FirstName = $qu->param("fname");
	&VerifyField($FirstName);
}

if ($qu->param("lname") eq "") {
	$missing_field =
		"$missing_field<br>Last Name";
} else {
	$LastName = $qu->param("lname");
	&VerifyField($LastName);
}

if ($qu->param("address") eq "") {
	$missing_field =
		"$missing_field<br>Address";
} else {
	$Address = $qu->param("address");
	&VerifyField($Address);
}

if ($qu->param("city") eq "") {
	$missing_field =
		"$missing_field<br>City";
} else {
	$City = $qu->param("city");
	&VerifyField($City);
}

if ($qu->param("state") eq "") {
	$missing_field =
		"$missing_field<br>State";
} else {
	$State = $qu->param("state");
	&VerifyField($State);
}

if ($qu->param("zip") eq "") {
	$missing_field =
		"$missing_field<br>Zip";
} else {
	$Zip = $qu->param("zip");
	&VerifyField($Zip);
}	

if ($missing_field eq "") {
	print("Content-type: text/html\r\n\r\n");
	print("<html><body>\n");
	print("Here is the data I have.<br>\n");
	print("You submitted:<br>");
	print("First Name: <b> $FirstName</b><br>
		Last Name: <b> $LastName</b><br>
		Address: <b> $Address</b><br>
		City: <b> $City</b><br>
		State: <b> $State</b><br>
		Zip: <b> $Zip</b><br>\n");
} else {
	$eh->Error($ErrorCodes::MISSING_FIELD,
		   "I didn't receive the following fields:<br> $missing_field",
		   1);
}

# 
# sub VerifyField
# 
# Redirects user to appropriate error page if
# fields contain illegal characters, otherwise
# returns nothing
#
sub VerifyField {
	local $field = shift;
	if ($field =~ /[;><&\*`\|]/) {
		$eh->Error($ErrorCodes::ILLEGAL_CHARACTERS,
			   "Detected illegal meta characters in form.",
			   1);
	}
}
