#!/usr/bin/perl
#Content-type directive tells the browser that the data
#is is plain text format
print "Content-type: text/Plain\n\n";

# open the logfile
$filename="logfile.txt";
open (IN,$filename) or die("Cannot open $filename: $!");

#read in from logfile one line at a time
while(<IN>) {
	chop; # get rid of hanging newline

	#split the record into it's fields
	($IP,$document,$date,$referer)=split/\|/;

	#increment the the value for the occurrence
	#of each field execpt for the date field
	$docHash{$document}++;
	$IPHash{$IP}++;
	$referHash{$IP}++;
	$totalhits++;
}
close IN;

#output IP data
#get the list of unique values for this
#field, sorted by the number of hits per value
@IPKeys=sort {$IPHash{$b}<=>$IPHash{$a}} keys %IPHash;
#get the number of different values for the field
$numKeys=$#IPKeys+1;

#print the number of hits for each value of the field
print "\nNumber of unique IP addresses:$numKeys\n";
print "Number of hits per IP address...\n";
foreach (@IPKeys) {
	print "$_: $IPHash{$_}\n";
}

#output document data
@docKeys=sort {$docHash{$b}<=>$docHash{$a}} keys %docHash;
$numKeys=$#docKeys+1;
print "\nNumber of unique documents:$numKeys\n";
print "Number of hits per page...\n";
foreach (@docKeys) {
	print "$_: $docHash{$_}\n";
}

#output referer data
@referKeys=sort {$referHash{$b}<=>$referHash{$a}} keys %referHash;
$numKeys=$#referKeys+1;
print "\nNumber of unique referers:$numKeys\n";
print "Number of hits per referer...\n";
foreach (@referKeys) {
	print "$_: $referHash{$_}\n";
}

#output total hits
print "\n\nTotal hits: $totalhits\n";

