#!/usr/bin/perl

#the use directive tells Perl which functions to
#import from CGI.pm into the current package
use CGI qw(:standard *table);

#outputs the Content-type declaration and a simple
#HTML header
print header(),start_html(-title=>'Log Analyzer');

#define the fieldnames
@fieldNames=("IP","document","date","referer");

#if the param() function returns true, you know that
#the form values are present (this occurs after the
#first time the script is run, and the form is
#submitted
if (param() ) {
   	#open the log file
	$filename="logfile.txt";
	die("Usage: parselog filename") if not $filename;
	open (IN,$filename) or die("Cannot open $filename: $!");

	#you could fill these in to specify default values
	$IPExp="";
	$refererExp="";
	$documentExp="";
	$dateExp="";

	#loop through each field name, creating the hash
	#reference where the hit counts will be stored
	#and set the value of each expression variable
	#to the values from the form
	foreach(@fieldNames){
		$fields{$_}={};
		$expName=$_."Exp";
		$$expName=param("$_");
	}

	#read records in from the file
	LOOP: while(<IN>) {
		chop;

		#split up the record into its fields
		($IP,$document,$date,$referer)=split/\|/;

		#loop through each field, validating the values
		#with the processAll function
		foreach (@fieldNames) {
			$expName=$_."Exp";
			next LOOP unless processAll($_,$$expName);
		}

		#increment the counters for each field
		foreach (@fieldNames) {
			next if /date/;
			$fields{$_}->{$$_}++;
		}
		$totalhits++;
	}
	close IN;

	#output the results for each field
	foreach (@fieldNames) {
		next if /date/;
		%thisHash=%{$fields{$_}};
		@thisKeys=
		sort {$thisHash{$b}<=>$thisHash{$a}} keys %thisHash;
		$numKeys=$#thisKeys+1;
		print "\nUnique $_ count:$numKeys\n",br;
		print "Number of hits per $_ ...\n",br;
		foreach (@thisKeys) {
			print "$_: $thisHash{$_}\n",br;
		}
		print br;
	}
	print "\n\nTotal hits: $totalhits\n";

	#the function which evaluates a field's value
	#based on the provided expression
	sub processAll {
		$fieldname=shift;
		$exp=shift;
		return 1 if (! $exp);
		if($fieldname eq "date"){
			(my $sDate, my $eDate)=split /,/,$exp;
			$temp=$date;
			$date=~/\[(.+?):(.+?) /;
			$date=$1;
			($m,$d,$y)=split /\//,$date;
			($sMonth,$sDay,$sYear)=split /\//,$sDate;
			($eMonth,$eDay,$eYear)=split /\//,$eDate;
			return 0 if ($y < $sYear || $y > $eYear);
			return 0 if ($y==$sYear && $m < $sMonth) ||
			($y==$eYear && $m>$eMonth);
			return 0 if($y==$syear && $m==$sMonth && $d<$sDay)||
			($y==$eYear && $m==$eMonth && $d>$eDay);
			return 1;
		}elsif ($fieldname eq "document") {
			$document=~s/.+?\/(.+) .+/$1/;
		}
		return $$fieldname=~/$exp/i;
		return 0;
	}
}
#start the HTML form
print start_form(-method=>'POST',-action=>'parselog4.cgi');

#start an HTML table
print start_table;

#add a row in the table containing the field name
#and an input field for each field name's expression
foreach (@fieldNames) {
	print Tr[td(["$_",textfield(-name=>"$_",-size=>'30')])];
	print "\n";
}

#add the submit button
print TR[td({-colspan=>2},[submit(-value=>'Analyze Log')])];

#end the table and the form
print end_table;
print end_form;
