#!/usr/bin/perl  # this should point to your own perl directory
push @INC, ".";
package XMLStyle; # this declares the current package

use XML::Parser;

sub new {
        my $type=shift; # this will be XMLStyle
        my $self={};
        # add variable declarations here
        $self->{levels}=[];
        $self->{textEntries}={}; 
	  $self->{attTypes}={};
	  $self->{strings4Sub}=[];
	  $self->{subs}={};
        return bless $self, $type;
}

sub initStyles{
        
        # read in argument list
        local $self=shift;
        my $styleFileOrString=shift;

        #create new parser object with no Style
        my $p=new XML::Parser();

        #set the parser's handlers
        $p->setHandlers(Start => \&style_start_handler,
        Char => \&style_char_handler,
        End => \&style_end_handler,
        Proc=>\&style_proc_handler
        );
        
        #initiate parsing
        $p->parse($styleFileOrString);
}

sub style_start_handler {

          #obtain the Expat object and the name of the element
          #whose opening tag triggered the event
        my $p=shift;
        my $ename=shift;

        if ($ename eq "STYLEBLOCK") {
                $self->{inStyleBlock}=1;
        }elsif($self->{inStyleBlock}){
                if($ename eq "START_TEXT"){
                        $self->{currentSection}="START_TEXT";
                }elsif($ename eq "END_TEXT"){
                        $self->{currentSection}="END_TEXT";
                }elsif($ename eq "ATT_TEXT"){
                
                  #loop throught the attributes of the ATT_TEXT element
                  while (@_) {
        
                        # allow the user to provide the name and the
                        # value attribute in any order
                        my $nameOrValue=shift;
                        if ($nameOrValue eq "NAME") {
                                $self->{currentName}=shift;
                        }elsif($nameOrValue eq "VALUE"){
                                $self->{currentValue}=shift;
                        }
                  }
                  $self->{inAttribute}=1;

                }else{
                   $self->{currentElement}=$ename;
                  push @{self->{levels}},$ename
                }
        }
}

sub style_end_handler {
        my ($p,$ename)=@_;

        if ($ename eq "STYLEBLOCK") {
                $self->{inStyleBlock}=0;
        }elsif($ename eq "START_TEXT"){
                $self->{currentSection}="";
        }elsif($ename eq "END_TEXT"){
                $self->{currentSection}="";
          }elsif($ename=~/ATT_TEXT/){
                $self->{currentAttribute}="";
                $self->{currentValue}="";
                $self->{inAttribute}=0;

          }else{
                $self->{currentElement}=pop @{$self->{levels}};
        }
}

sub style_char_handler {
        my ($p,$data)=@_;
        return unless ($data=~/\S/);
        # build key for this element
        if (($self->{currentSection}) eq "START_TEXT") {
                $key="start_";
        }elsif (($self->{currentSection}) eq "END_TEXT") {
                $key="end_";
        }
        $key.=$self->{currentElement};

        # modify key
        if ($self->{inAttribute}){
                $key.="_".$self->{currentName};
                $key.="_".$self->{currentValue};
        }

        # add the character data to the value retrieved
        # by this key
        $self->{textEntries}->{$key}.=$data;
}

# style parser's processing instruction handler
sub style_proc_handler{
        my $p=shift;
        my $funcName=shift;
        my $args=shift;

        #try to call the function
        &$funcName($p,$args) or die "Function $funcName not found";
}

sub sub_att_value {
        my $p=shift;
        my $attributeName=shift;

        #generate unique string
        my $string4Sub="ATTVALUE____$attributeName";
        style_char_handler($p,$string4Sub);
}

sub parse {
        local $self=shift;
        my $sourceFileOrString=shift;
        my $p=new XML::Parser();
        $p->setHandlers(Start => \&source_start_handler,
                End => \&source_end_handler,
                Char => \&source_char_handler,
		Attlist => \&source_attlist_handler,
		Element => \&source_element_handler,
		Final => \&source_final_handler
                );
        $p->parse($sourceFileOrString);
        
        return $self->{html};
}

sub source_start_handler{
        my $p=shift;
        my $ename=shift;

        # start tag key
        $key = "start_".$ename;

        # end tag key
        $key2 = "end_".$ename;

        my $data=$self->{textEntries}->{$key};
        my $data2=$self->{textEntries}->{$key2};

        while(@_){
                my $name=shift;
                my $value=shift;

                # create attribute keys
                my $key="start_".$ename."_".$name."_".$value;
                my $key2="end_".$ename."_".$name."_".$value;

                # create "any value" keys
                my $anykey="start_".$ename."_".$name."_*";
                my $anykey2="end_".$ename."_".$name."_*";

                # save the data before the attribute text is sought
                my $dataBeforeAttribute=$data;
        
                # retrieve the formatting text for this attribute name
                # and value
                $data.=$self->{textEntries}->{$key};

                # if the data hasn't changed, use the "any value" text
                if ($data eq $dataBeforeAttribute){
                        $data.=$self->{textEntries}->{$anykey};
                }

                # do the same for the end attribute text
                $dataBeforeAttribute=$data2;
                $data2=($self->{textEntries}->{$key2}).$data2;
                if ($data2 eq $dataBeforeAttribute) {
                        $data2=($self->{textEntries}->{$anykey2}).$data2;
                }

                $attSubString="ATTVALUE____$name";
                $data=~s/$attSubString/$value/;
                $data2=~s/$attSubString/$value/;

		    # construct the key for this element and attribute name
		    $elementAttribute=$ename."_".$name;

		    # retrieve the data type for this attribute
		    my $attType=$self->{attTypes}->{$elementAttribute};

		    if ($attType eq "IDREF" && 
		     	$self->{elementModels}->{$ename} eq "(EMPTY)"){
				# generate a string that will later be replaced
				$string4Sub="substring____".$value;
		    }

		    if ($attType eq "ID"){
			    unshift @{$self->{strings4Sub}},"substring____".$value;
			    $IDatt="true";
			    $data.="<A NAME=\"$value\">";
		    }

        }
	  if (! $IDatt) {
		unshift @{$self->{strings4Sub}}, "";
	  }

        # add the start data to the final return string
        $self->{html}.=$data;
	  
	  #add string for later substitution
	  $self->{html}.=$string4Sub;
	  $string4Sub="";

        # if there is no array for this key, create one
        if (! $self->{endText}->{$key2}) {
                $self->{endText}->{$key2}=[];
        }

        # save the end data for use by the end handler
        push @{$self->{endText}->{$key2}},$data2;

}

sub source_end_handler{
        my ($p,$ename)=@_;

        # create key
        my $key="end_".$ename;

        # retrieve the end text for this key
        # and append the data to the return string
        $self->{html}.=(pop @{$self->{endText}->{$key}});

	shift  @{$self->{strings4Sub}};
}

sub source_char_handler{
	my $p=shift;
	my $data=shift;

	# get the strings4Sub value for the last open element
	my $string4Sub=$self->{strings4Sub}->[0];
	
	if ($string4Sub) {
		#add data to hash entry keyed by the
		#current string for substitution
		$self->{subs}->{$string4Sub}=$data;
	}
	#also add the data to the html string
	$self->{html}.=$data;
}


sub source_attlist_handler{
	my ($p,$thisElement,$attributeName,$attributeType,$attributeDefault,$attributeFixed)=@_;

	# generate a key from the element and attribute name
	my $elementAttribute=$thisElement."_".$attributeName;

	#store the data type in the attTypes hash                
	$self->{attTypes}->{$elementAttribute}=$attributeType;                      
}

sub source_element_handler{
	my ($p,$ename,$dataModel)=@_;
	$self->{elementModels}->{$ename}=$dataModel;
}

sub source_final_handler {
	foreach (keys %{$self->{subs}}) {
		# substitute the key with the value
		$self->{html}=~s/$_/$self->{subs}->{$_}/g;
	}
}
