#!/usr/bin/perl
# "xml2html.cgi" a simple script using the XMLStyle module

# if Perl can't find the module use the next line
# push @INC, "directory/where/module/is";

require XMLStyle;
use CGI qw(:standard -any);

#print "Content-type: Text/Plain\n\n";

my $q=new CGI();
my @paramnames=$q->param();
my @params=();
my @elements=();
foreach (@paramnames){
	my ($numandname,$value)=($_,$q->param("$_"));
	my ($num,$name)=split /#/,$numandname;
	$params[$num]={name=>$name,value=>$value};
	if (! $filename){
		if ($name eq "START_TAG"){
		 	$firstElement=$value;
		}elsif($name eq "FILENAME"){
			$filename=$value;
			if (! $filename){
				$filename=create_filename($firstElement);
				$params[$num]->{value}=$filename;
			}
		}
	}
}


####process require content tags
my @levels=();
my @index=();
my %require_content=();

LOOP: for ($i=0;$i<@params;$i++){
	next LOOP if (! $params[$i]);
	my ($name,$value)=($params[$i]->{name},$params[$i]->{value});
	if ($name eq "START_TAG"){
		unshift @levels,$value;
		unshift @index,$i;
	}elsif ($name eq "REQUIRE_CONTENT"){
		$require_content{$value}=1;
		$params[$i]="";
	}elsif ($name eq "END_TAG"){
		if ($value eq $levels[0] && $require_content{$value}){
			$params[$i]="";
			$params[$index[0]]="";
		}
		shift @levels;
		shift @index;
	}elsif ($name eq $levels[0]){
		if ($value=~/\S/){
			@levels=();
		}
	}	
}



my $xml="";
open (IN,"$firstElement.header") || die ("Couldn't open header file");
while (<IN>){
	$xml.=$_;
}

my @levels=();
LOOP: for ($i=0;$i<@params;$i++){
	next LOOP if (! $params[$i]);
	my ($name,$value)=($params[$i]->{name},$params[$i]->{value});
	if ($name eq "START_TAG"){
		if ($inStartTag){
			$function.="});";
			$xml.=("    " x $#levels);
			$xml.=(eval($function))."\n";
		}
		$function='$q->start_'.$value."({";
		unshift @levels,$value;
		$inStartTag="true";		
	}elsif ($name eq "END_TAG"){
		if ($inStartTag){
			$function.="});";
			$xml.=("    " x $#levels);
			$xml.=(eval($function))."\n";
		}
		$function='$q->end_'.$value."();";
		$xml.=("    " x $#levels);
		$xml.=(eval($function))."\n";
		$inStartTag=0;
		shift @levels;
	}elsif ($name eq $levels[0]){
		if ($inStartTag){
			$function.="});";
			$xml.=("    " x $#levels);
			$xml.=(eval($function))."\n";
		}
		$inStartTag=0;
		$xml.=("    " x ($#levels+1));
		$xml.=$value."\n";
	}else{
		$function.="-$name => \"$value\",";
	}
	
}

open (OUT,">$filename") || die ("couldn't open destination file");
print OUT $xml;
close OUT;

#print "$xml\n";
my $style=new XMLStyle();
my $styleFile="style_$firstElement.xml";
open (STYLE, $styleFile);
$style->initStyles(\*STYLE);
open (SOURCE, $filename);
my $html=$style->parse(\*SOURCE);
print "Content-type: Text/Html\n\n";
print $html;

sub create_filename{
	my $element=shift;
	my $highestValue=0;
	while (glob("$element*.xml")){
		if (/$element_(\d+)\.xml/){
			$highestValue=$1 if ($1 > $highestValue);
		}	
	}
	my $number=$highestValue+1;
	my $filename=$element."_".$number.".xml";
	return $filename
}
