import java.awt.event.*;
import java.awt.*;
import java.util.*;

class Chat extends Panel implements CompHandler,ActionListener{
	private Hub parent;
	private String currentElement;
	private String currentID;
	private Vector chatters;

	//AWT variables
	private TextArea chatArea;
	private TextArea chatterList;
	private TextField input;
	private TextField todo;
	private GridBagLayout gb;	
	private GridBagConstraints gbc;

	public Chat(Hub hub, int w, int h){
		setSize(w,h);
		chatters=new Vector(1,1);
		parent=hub;
		initializeAWTComponents();
	}
	public void initializeAWTComponents(){
		//initialize layout
		gb=new GridBagLayout();	
		gbc=new GridBagConstraints();
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets=new Insets(5,5,5,5);
		setLayout( gb);

		//create conversation text area
		chatArea=new TextArea(null,15,50);
		chatArea.setEditable(false);	
		addWidget(chatArea,0,0,2,2);

		//add Label for chatterList
		addWidget(new Label("Who's here?"),2,0,1,1);	

		//create chatterList text area
		chatterList=new TextArea(null,10,20,TextArea.SCROLLBARS_VERTICAL_ONLY);
		chatterList.setEditable(false);
		refreshChatterList();
		addWidget(chatterList,2,1,1,1);
	
		//create talk Label
		addWidget(new Label("SAY -->"),0,2,1,1);
	
		//create talk text field
		input=new TextField(50);
		input.addActionListener(this);
		addWidget(input,1,2,2,1);
	
		//create do Label
		addWidget(new Label("DO -->"),0,3,1,1);

		//create do text field
		todo=new TextField(50);
		todo.addActionListener(this);
		addWidget(todo,1,3,2,1);

	}
	public void addWidget(Component c,int x,int y, int w, int h){
		gbc.gridx=x;
		gbc.gridy=y;
		gbc.gridwidth=w;
		gbc.gridheight=h;
		add(c,gbc);
	}
	public void actionPerformed(ActionEvent evt) {
		String text="";
		if (evt.getSource().equals(input)){
			text = "<CHAT><SAY>"+input.getText()+"</SAY></CHAT>";
			input.setText("");
		}
		if (evt.getSource().equals(todo)){
			text = "<CHAT><DO>"+todo.getText()+"</DO></CHAT>";
			todo.setText("");
		}
		parent.sendUpdate(text);	
	}

	public void addEntity(String Id, String tagName, String data){
		chatters.addElement(Id);
		chatArea.append(Id+" is here.\n");
		refreshChatterList();
	}
	public void updateEntity(String Id, String tagName, String data){
		currentID=Id;
		parent.parse(this,data);
	}
	public void disconnectEntity(String Id, String tagName, String data){
		chatters.removeElement((Object)Id);
		chatArea.append(Id+" has left the building.\n");
		refreshChatterList();
	}
	public void refreshChatterList(){
		chatterList.setText("");
		for (int i=0;i<chatters.size();i++) {
			chatterList.append(((String)chatters.elementAt(i)));
			chatterList.append("\n");
		}
	}
	public void startElement(String elname){
		currentElement=elname;
	}
	public void charData(char ch[],int start,int length){
		if (currentElement.equals("SAY")){
			chatArea.append(currentID+" says: "+(new String(ch)));
			chatArea.append("\n");
		}
		if (currentElement.equals("DO")){
			chatArea.append(currentID+" "+(new String(ch)));
			chatArea.append("\n");
		}
	}
	public void endElement(String elname){}
}
