#!/usr/bin/perl
#
# catengine.cgi
# From: Open Source Linux Web Projects
#
push(@INC, "/home/httpd/www/catalog/lib-catalog");
require HeaderFooter;
require Content;
require Navigator;
require Template;
require Producer;
use CGI;

package main;
#
# Initialize object references
$hed = new HeaderFooter;
$nav = new Navigator;
$con = new Content;
$foot = new HeaderFooter;
$tp = new Template;
$prod = new Producer;
$httpCGI = new CGI;

#########################################
# Main


#
# pull HTTP Header and Query String info
$agent      = $ENV{"HTTP_USER_AGENT"};
$my_name    = $ENV{"SCRIPT_NAME"};
$category   = $httpCGI->param(category);
$product    = $httpCGI->param(product);

#
# Initializiations
$fsize = "";
$productListingHeader = "";
$productFeatureHeader = "";
$tilerTease = "";

#
# This is a link to tiler.cgi demo
# script
$tilerTease =
   "<a href=tiler.cgi?tilename=$product>
   <b>Click here!</b></a> to see this tile
   in action.";

#
# Set defaults if script is called without
# parameters
if ($category eq "" and $product eq "") {
   $category = "about";
}

#
# create page header
$hed->setWidth("550");
$hed->setHeight("127"); 
$hed->loadContent("./catalogHeader.html");

#
# create menu bar
$nav->setWidth("125");
$nav->addSection("tiles", 
   "<a href=\"$my_name?category=tiles\">
    <img src=images/tiles_on.jpg 
    border=0></a><br><br>",
   "<a href=\"$my_name?category=tiles\">
   <img src=images/tiles_off.jpg border=0 
   width=125 height=25></a>");

$nav->addSection("space", 
   "<a href=\"$my_name?category=space\">
   <img src=images/space_on.jpg 
   border=0></a><br><br>",
   "<a href=\"$my_name?category=space\">
   <img src=images/space_off.jpg border=0 
   width=125 height=25></a>");

$nav->addSection("ordering", 
   "<a href=\"$my_name?category=ordering\">
   <img src=images/ordering_on.jpg 
   border=0></a><br><br>",
   "<a href=\"$my_name?category=ordering\">
   <img src=images/ordering_off.jpg border=0 
   width=125 height=25></a>");

$nav->addSection("about", 
   "<a href=\"$my_name?category=ordering\">
   <img src=images/about_on.jpg 
   border=0></a><br><br>",
   "<a href=\"$my_name?category=about\">
   <img src=images/about_off.jpg border=0 
   width=125 height=25></a>");

$nav->setActiveSection($httpCGI->param(category));

#
# Change font size per browser
if ($agent =~ "MSIE") {
   $fsize = "size=2";
} 

#
# Establish Category and Product headers
$categoryHeader = new Content;
$categoryHeader->loadContent(
   "./${category}_CatHeading.html");
$categoryHeader->setContentStartTags(
   "<font face=arial,helvetica>
    <h1>$category</h1></font>
    <font face=verdana,helvetica $fsize>");
$categoryHeader->setContentEndTags("</font>");
$categoryHeader->setWidth("425");
$categoryHeader->setHeight("90");

$productFeatureHeader = new Content;
$productFeatureHeader->setContent(
   "<font face=arial,helvetica>
   <h1>$product Detail</h1></font>");
$productFeatureHeader->setWidth("425");
$productFeatureHeader->setHeight("40");

#
# Configure and determine main content
# by determining if browser is after a
# product or a category
if ($product eq "") {
   #
   # Display category, ordering, or about
   # information
   if ($category eq "ordering") {
      #
      # Display ordering information
      $con->setContentStartTags(
         "<p><font face=verdana,helvetica $fsize>");
      $con->setContentEndTags(
         "</font></p>");
      $con->loadContent("./ordering.html");
      $con->setWidth("425");
      $con->setHeight("300");
   } else {
      if ($category eq "about") {
         #
         # Display "about Celestial Graphics" information
         $con->setContentStartTags(
            "<p><font face=verdana,helvetica $fsize>");
         $con->setContentEndTags(
            "</font></p>");
         $con->loadContent("./about.html");
         $con->setWidth("425");
         $con->setHeight("300");
   
      } else {
         #
         # retrieve all HTML files/products
         # for this cateogry
         $thisContent = "";
         opendir(CATEGORY, "./$category");
         @products = readdir(CATEGORY);
         foreach $product (@products)
         {
            if ($product =~ html) {
               $product =~ s/.html//g;
               $thisContent = "$thisContent <a
href=\"$my_name?category=$category&product=$product\">
                 $product</a></b><br>";
            }
            
         }
         #
         # Configure content object with
         # cateogry information.
         $con->setContentStartTags(
            "<p><font face=verdana,helvetica $fsize>");
         $con->setContentEndTags("</font></p>");
         $con->setContent($thisContent);
         $con->setWidth("425");
         $con->setHeight("200");
      }
   }
} else {
   #
   # Display this product within this cateogry
   $con->setContentStartTags(
      "<p><font face=verdana,helvetica $fsize>
      <img src=\"product_images/$product.gif\" 
      align=left>");
   if ($category eq "tiles") {
      $con->setContentEndTags(
         "<br><br>$tilerTease</font></p>");
   } else {
      $con->setContentEndTags("<br><br></font></p>");
   }
   $con->loadContent("./$category/$product.html");
   $con->setWidth("425");
   $con->setHeight("200");
}

#
# Configure footer
$foot->setWidth("550");
$foot->setHeight("25");
$foot->loadContent("./catalogFooter.html");

#
# Use template to organize content objects
print("Content-type: text/html\n\n");
print("<html><body>\n");

$tp->setWidth($hed->getWidth());
$tp->setTop($hed);
$tp->setLeftWidth($nav->getWidth());
$tp->setLeft($nav);
$tp->setRightWidth($con->getWidth());
if ($product eq "") {
   $tp->setRight($categoryHeader, $con);
} else {
   $tp->setRight($productFeatureHeader,
      $con);
}
$tp->setBottom($foot);

#
# Use producer to display template
$prod->addTemplate($tp);
$prod->displayTemplate();

print("</body></html>\n");



