#
# Content.pm
#
#  This class is a container for
#  content.  Is derived from HeaderFooter.pm
#
package Content;
@ISA = qw( HeaderFooter );

#
# constructor
#  Initializes data members
sub new {
   my $type = shift;
   my $self = new HeaderFooter;

   $self->{contentStartTags} = "";
   $self->{contentEndTags} = "";

   return bless $self, $type;
}

#
# method: setContentStartTags
#  Sets markup to be displayed within
#  containing table and before content
#  (such as font information if content
#   is raw text)
sub setContentStartTags {
   my ($self, $cst) = @_;
   $self->{contentStartTags} = $cst;
}

#
# method: getContentStartTags
#  Returns start tags string
sub getContentStartTags {
   my $self = shift;
   return $self->{contentStartTags};
}

#
# method: setContentEndTags
#  End tags for whatever tags were
#  started using setContentStartTags()
sub setContentEndTags {
   my ($self, $cet) = @_;
   $self->{contentEndTags} = $cet;
}

#
# method: getContentEndTags
#  Returns end tags string
sub getContentEndTags {
   my $self = shift;
   return $self->{contentEndTags};
}

#
# method: display()
#  We override display() here to add
#  in handler for our start and end tags
#  methods
sub display {
   my $self = shift;
   #
   # Begin HTML output...
   print("<table width=\"");
   print($self->getWidth());
   print("\" height=\"");
   print($self->getHeight());
   print("\" cellpadding=\"");
   print($self->getCellPadding());
   print("\" cellspacing=\"");
   print($self->getCellSpacing());
   print("\">\n");
   print("<tr><td");
   if (($self->getContainerBgColor()) eq "")   {
      print(">\n");
   } else {
      print(" bgcolor=");
      print($self->getContainerBgColor());
      print(">\n");
   }
   #
   # determine if start or end tags have
   # been used
   if (($self->getContentStartTags()) eq "") {
      print($self->getContent());
   } else {
      print($self->getContentStartTags());
      print($self->getContent());
      print($self->getContentEndTags());
   }
   print("\n</td></tr>\n</table>\n");
}

1;

