/*
 * Decompiled with CFR 0.152.
 */
package org.vstm.fwk.client.ui.xswing.core;

import javax.accessibility.Accessible;
import javax.swing.JPanel;
import org.vstm.fwk.client.ui.xswing.core.event.XSListener;
import org.vstm.fwk.client.ui.xswing.core.model.XSModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XSComponent<M extends XSModel<L, E>, L extends XSListener<E>, E extends Enum>
extends JPanel
implements Accessible {
    protected M model;
    protected L modelListener;

    public XSComponent() {
        this(null);
    }

    public XSComponent(M m) {
        if (m == null) {
            m = this.createDefaultModel();
        }
        this.setModel(m);
        this.initView();
        this.installViewListeners();
        this.initViewValues();
    }

    protected abstract M createDefaultModel();

    public M getModel() {
        return this.model;
    }

    public void setModel(M m) {
        if (m == null) {
            throw new IllegalArgumentException("model must be non-null");
        }
        M m2 = this.model;
        if (m2 != null) {
            m2.removeXSListener(this.modelListener);
        }
        this.model = m;
        this.installModelListener();
        if (m2 != null) {
            this.initViewValues();
        }
        this.firePropertyChange("model", m2, this.model);
    }

    protected abstract void initView();

    protected abstract void initViewValues();

    private void installModelListener() {
        if (this.modelListener == null) {
            this.modelListener = this.createDefaultPropertyChangeHandler();
            if (this.modelListener == null) {
                throw new NullPointerException("modelListener must be non-null (createDefaultPropertyChangeHandler() must return a non-null object)");
            }
        }
        this.model.addXSListener(this.modelListener);
    }

    public void addXSListener(L l) {
        this.model.addXSListener(l);
    }

    public void removeXSListener(L l) {
        this.model.removeXSListener(l);
    }

    protected abstract void installViewListeners();

    protected abstract L createDefaultPropertyChangeHandler();
}

