package com.petex.transport;

import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebService;
import java.util.logging.Logger;

/**
 * Can be tested at http://localhost:8080/petex/DeliveryService?Tester
 * WSDL at http://localhost:8080/petex/DeliveryService?WSDL
 *
 * @author Antonio Goncalves
 */
//@WebService(serviceName = "TITI") alors Endpoint Address URI: petex/TITI
// et la classe gnr pour le client DeliveryServiceImplService.java est renomm en TITI
//@WebService(name = "TUTU") ne fonctionne pas au deploiement The serviceName cannot be retrieved from an interface

//@WebService(targetNamespace = "TUTU") ne fonctionne pas au deploiement The serviceName cannot be retrieved from an interface
//Dans la classe gnre SayHello
//@XmlRootElement(name = "sayHello", namespace = "TUTU")
//@XmlType(name = "sayHello", namespace = "TUTU")
//
//Dans la classe gnre SayHelloResponse
//@XmlRootElement(name = "sayHelloResponse", namespace = "TUTU")
//@XmlType(name = "sayHelloResponse", namespace = "TUTU")

@WebService
public class Delivery {

    // ======================================
    // =             Attributs              = 
    // ======================================
    private Logger logger = Logger.getLogger("com.petex.transport");
    private final String cname = this.getClass().getName();

    // ======================================
    // =             Constantes             =
    // ======================================

    // ======================================
    // =            Constructeurs           =
    // ======================================

    // ======================================
    // =          Methodes publiques        = 
    // ======================================

    @WebMethod
    @Oneway
    public void deliverItems(DeliveryPlace from, DeliveryPlace to, String reference) {
        final String mname = "deliverItems";
        logger.entering(cname, mname);

        logger.info("Delivery Order Received");
        logger.info("Deliver from " + from);
        logger.info("Deliver to " + to);
        logger.info("Reference n " + reference);

        logger.exiting(cname, mname);
    }

    // ======================================
    // =          Methodes Protges        = 
    // ======================================

    // ======================================
    // =             Accesseurs             = 
    // ======================================

    // ======================================
    // =           Methodes Prives         =
    // ======================================

    // ======================================
    // =   Methodes hash, equals, toString  =
    // ======================================
}