package com.yaps.petstore.client.ui.order;


import static com.yaps.petstore.client.ui.util.YapsViewType.*;


import java.util.EventObject;

import javax.swing.JOptionPane;

import org.vstm.fwk.client.ui.xswing.core.event.XSEvent;

import com.yaps.petstore.client.delegate.OrderDelegate;
import com.yaps.petstore.client.ui.order.event.OrderAdapter;
import com.yaps.petstore.client.ui.order.event.OrderEventPropertyName;
import com.yaps.petstore.client.ui.order.model.OrderModel;
import com.yaps.petstore.client.ui.util.YapsCrudFrame;
import com.yaps.petstore.client.ui.util.YapsViewType;
import com.yaps.petstore.entity.order.Order;


public class OrderCrudFrame extends YapsCrudFrame<OrderPane> {
    
    private static final long serialVersionUID = 3371400413037437133L;
    
    
    public OrderCrudFrame(final OrderPane mainPane) {
        super(mainPane);
        
        mainPane.getModel().addXSListener(new OrderAdapter() {
            
            @Override
            public void identifierChanged(
                    XSEvent<OrderEventPropertyName, Long> evt) {
                initTitle(mainPane.getViewType());
            }
            
        });
    }
    
    
    public void findActionPerformed(EventObject evt) {
        final String actionName = "find";
        
        OrderModel model = mainPane.getModel();
        Long identifier = model.getIdentifierToFind();
        
        if (identifier == null) {
            displayWarning("Identifier must be non null");
            
            return;
        }
        
        try {
            Order order = OrderDelegate.findOrder(identifier);
            
            if (order == null) {
                JOptionPane.showMessageDialog(this,
                        "This order has not been found", "Warning",
                        JOptionPane.WARNING_MESSAGE);
            } else {
                model.setOrder(order);
                
                mainPane.setViewType(DELETE);
            }
        } catch (Exception exc) {
            displayException(className, actionName, exc);
        }
    }
    
    
    public void createActionPerformed(EventObject evt) {
    }
    
    public void readActionPerformed(EventObject evt) {
    }
    
    public void updateActionPerformed(EventObject evt) {
    }
    
    public void deleteActionPerformed(EventObject evt) {
        final String actionName = "delete";
        
        OrderModel model = mainPane.getModel();
        Order order = model.getOrder();
        
        try {
            OrderDelegate.deleteOrder(order);
            
            dispose();
        } catch (Exception exc) {
            displayException(className, actionName, exc);
        }
    }
    
    
    public void resetActionPerformed(EventObject evt) {
        OrderModel model = mainPane.getModel();
        YapsViewType viewType = mainPane.getViewType();
        
        if (viewType != FIND || viewType != CREATE
                || viewType != FIND_OR_CREATE) {
            model.setIdentifierToFind(null);
        }
        
        model.reset();
    }
    
}