package com.yaps.petstore.client.ui.util;


import static com.yaps.petstore.util.ExceptionUtils.*;


import java.util.logging.Logger;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import com.yaps.petstore.util.Constants;


public class YapsFrame extends JFrame {
    
    private static final long serialVersionUID = -7476477854043392884L;
    

    // ======================================
    // = Attributs =
    // ======================================
    protected final transient String className = getClass().getName();
    protected Logger logger = Logger.getLogger(Constants.LOGGER_CLIENT);
    
    
    // ======================================
    // = Methodes Protges =
    // ======================================
    protected void displayException(String sourceClass, String sourceMethod,
            Throwable throwable) {
        Throwable cause = getRootCause(throwable);
        if (isApplicationException(cause)) {
            displayWarning(cause.getMessage());
        } else {
            displayError(throwable.getMessage());
            logger.throwing(sourceClass, sourceMethod, throwable);
        }
    }
    
    protected void displayWarning(String message) {
        JOptionPane.showMessageDialog(this, message, "Warning",
                JOptionPane.WARNING_MESSAGE);
    }
    
    protected void displayError(String message) {
        JOptionPane.showMessageDialog(this, message, "Error",
                JOptionPane.ERROR_MESSAGE);
    }
    
}
