package com.yaps.petstore.entity.catalog;

import com.yaps.petstore.exception.ValidationException;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;

/**
 * Cette classe reprsente une Categorie du catalogue de la socit YAPS.
 * Le catalogue se divise en categories, en produits puis en articles.
 *
 * @author Antonio Goncalves
 * @see Product
 * @see Item
 */

@Entity
@Table(name = "t_category")
public class Category implements Serializable {

    // ======================================
    // =             Attributs              =
    // ======================================
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;
    @Column(nullable = false, length = 30)
    private String name;
    @Column(nullable = false)
    private String description;
    @OneToMany(mappedBy = "category", cascade = CascadeType.REMOVE, fetch = FetchType.LAZY)
    @OrderBy("name ASC")
    private List<Product> products;

    // ======================================
    // =             Constantes             =
    // ======================================

    // ======================================
    // =            Constructeurs           =
    // ======================================
    public Category() {
    }

    public Category(String name, String description) {
        this.name = name;
        this.description = description;
    }

    // ======================================
    // =     Methodes Lifecycle Callback    =
    // ======================================
    @PrePersist
    @PreUpdate
    private void validateData() {
        if (name == null || "".equals(name))
            throw new ValidationException("Invalid name");
        if (description == null || "".equals(description))
            throw new ValidationException("Invalid description");
    }

    // ======================================
    // =          Methodes publiques        =
    // ======================================

    // ======================================
    // =          Methodes Protges        =
    // ======================================

    // ======================================
    // =             Accesseurs             =
    // ======================================

    public Long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Product> getProducts() {
        return products;
    }

    public void setProducts(List<Product> products) {
        this.products = products;
    }
    // ======================================
    // =           Methodes Prives         =
    // ======================================

    // ======================================
    // =   Methodes hash, equals, toString  =
    // ======================================
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Category category = (Category) o;

        if (!description.equals(category.description)) return false;
        if (!id.equals(category.id)) return false;
        if (!name.equals(category.name)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result;
        result = id.hashCode();
        result = 31 * result + name.hashCode();
        result = 31 * result + description.hashCode();
        return result;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append("Category");
        sb.append("{id=").append(id);
        sb.append(", name='").append(name).append('\'');
        sb.append(", description='").append(description).append('\'');
        sb.append(", products=").append(products == null ? 0 : products.size());
        sb.append('}');
        return sb.toString();
    }
}
