package com.yaps.petstore.stateful;

import com.yaps.petstore.entity.catalog.Item;
import com.yaps.petstore.util.Constants;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Stateful;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/**
 * Cette classe reprsente un caddie lectronique.
 *
 * @author Antonio Goncalves
 */
@Stateful(name = "ShoppingCartSB")
public class ShoppingCartBean implements ShoppingCartLocal {

    // ======================================
    // =             Attributs              =
    // ======================================
    private List<CartItem> cartItems;

    private final String cname = this.getClass().getName();
    private Logger logger = Logger.getLogger(Constants.LOGGER_STATEFUL);

    // ======================================
    // =     Methodes Lifecycle Callback    =
    // ======================================

    @PostConstruct
    public void initialize() {
        String mname = "initialize";
        logger.entering(cname, mname);

        cartItems = new ArrayList<CartItem>();
    }

    @PreDestroy
    public void clear() {
        String mname = "clear";
        logger.entering(cname, mname);

        cartItems = null;
    }

    // ======================================
    // =          Methodes publiques        =
    // ======================================
    public void addItem(Item item) {
        String mname = "addItem";
        logger.entering(cname, mname, item);

        boolean itemFound = false;
        for (CartItem cartItem : cartItems) {
            // Si l'article existe dj dans le panier, on modifie uniquement sa quantit
            if (cartItem.getItem().equals(item)) {
                cartItem.setQuantity(cartItem.getQuantity() + 1);
                itemFound = true;
            }
        }
        if (!itemFound)
            // Sinon on le rajoute dans le panier
            cartItems.add(new CartItem(item, 1));

        logger.exiting(cname, mname, cartItems.size());
    }

    public void removeItem(Item item) {
        String mname = "removeItem";
        logger.entering(cname, mname, item);

        for (CartItem cartItem : cartItems) {
            if (cartItem.getItem().equals(item)) {
                cartItems.remove(cartItem);
                return;
            }
        }

        logger.exiting(cname, mname, cartItems.size());
    }

    public Float getTotal() {
        String mname = "getTotal";
        logger.entering(cname, mname);

        if (cartItems == null || cartItems.isEmpty())
            return 0f;

        Float total = 0f;

        // sum up the quantities
        for (CartItem cartItem : cartItems) {
            total += (cartItem.getSubTotal());
        }

        logger.exiting(cname, mname, total);
        return total;
    }

    public void empty() {
        String mname = "empty";
        logger.entering(cname, mname);

        cartItems.clear();
    }

    // ======================================
    // =             Accesseurs             =
    // ======================================
    public List<CartItem> getCartItems() {
        return cartItems;
    }

}
