function addListener(element, baseName, handler) {
    if (element.addEventListener)
        element.addEventListener(baseName, handler, false);
    else if (element.attachEvent)
        element.attachEvent('on' + baseName, handler);
} // addListener

function bindButtons() {
	addListener(document.getElementById('btnShowArgs1'), 'click', function() {
		showArgs1('hello', 1, 2, 3.14);
	});
	addListener(document.getElementById('btnShowArgs2'), 'click', function() {
		showArgs2('hello', 1, 2, 3.14);
	});
} // bindButtons

function showArgs1() {
    var msg = '';
    for (var index = 0; index < arguments.length; ++index)
        msg += arguments[index] + '\n';
    alert(msg);
} // showArgs1

function showArgs2() {
    alert(Array.prototype.join.call(arguments, '\n'));
} // showArgs2

addListener(window, 'load', bindButtons);
