/*
 * Script de l'exemple 2 pour une rponse "texte simple"
 * (pas de Prototype pour la partie AJAX).
 *
 * Ncessite Prototype 15.0_rc1+
 */

function getRequester() {
	var result = false;
/*@cc_on @*/
/*@if (@_jscript_version >= 5)
	try {
		result = new ActiveXObject("Msxml2.XMLHTTP");
	} catch (e) {
		try {
			result = new ActiveXObject("Microsoft.XMLHTTP");
		} catch (E) {
			result = false;
		}
	}
@end @*/
	if (!result && 'undefined' != typeof XMLHttpRequest) {
		try {
			result = new XMLHttpRequest();
		} catch (e) {
			result = false;
		}
	}
	return result;
} // getRequester

INTERVAL = 100;
var gProgressTimer = 0;

function checkProgress(id) {
	var node = $(id);
	var filler = node.getElementsByClassName('pbColorFill').first();
	var percent = node.getElementsByClassName('pbPercentage').first();
	var status = node.getElementsByClassName('pbStatus').first();
	var firstHit = 0 == gProgressTimer;
	if (!firstHit) {
		window.clearTimeout(gProgressTimer);
		gProgressTimer = 0;
	} else {
		Element.removeClassName(percent, 'over50');
		Element.removeClassName(status, 'done');
		Element.addClassName(status, 'working');
	}
	var requester = getRequester();
	requester.onreadystatechange = function() {
		if (4 == requester.readyState && 200 == requester.status) {
			var progress = parseInt(requester.responseText, 10);
			if (100 <= progress)
				progress = 100;
			filler.style.width = progress + '%';
			percent.firstChild.nodeValue = progress + '%';
			// Blanc sur vert, c'est plus joli... :-)
			if (progress > 50 && !Element.hasClassName(percent, 'over50'))
				Element.addClassName(percent, 'over50');
			if (100 == progress) {
				Element.removeClassName(status, 'working');
				Element.addClassName(status, 'done');
			} else
				gProgressTimer = window.setTimeout('checkProgress("' + id + '")', INTERVAL);
		}
	};
	requester.open('GET', '/whatsup', true);
	requester.send(null);
} // checkProgress

Event.observe(window, 'load', function() { checkProgress('progress') }, false);
