#! /usr/bin/env ruby

require 'net/http'
require 'uri'
require 'webrick'
include WEBrick

FEEDS = {
	'Standblog' => 'http://standblog.org/dotclear/atom.php',
	'Formats Ouverts' => 'http://formats-ouverts.org/atom.php',
	'IEBlog' => 'http://blogs.msdn.com/ie/atom.xml'
}

server = HTTPServer.new(:Port => 8042)
server.mount('/', HTTPServlet::FileHandler, './docroot')

server.mount_proc('/get_feed') do |request, response|
  # Critique pour pouvoir utiliser requester.responseXML !
  response['Content-Type'] = 'text/xml'
  feed = FEEDS[request.query['feed']]
  response.body = Net::HTTP.get(URI.parse(feed))
# Si vous tes derrire un Proxy, utilisez plutt cette ligne-ci
#  response.body = Net::HTTP::Proxy('serveur_proxy', numero_port).get(URI.parse(feed))
end

trap('INT') { server.shutdown }

server.start
