#! /usr/bin/env ruby

require 'erb'
require 'webrick'
include WEBrick

DEFAULT_NAME = 'Saisissez votre nom ici'
names = {}
sessionGen = 0

template_text = File.read('modele.rhtml')
page = ERB.new(template_text)

server = HTTPServer.new(:Port => 8042)
server.mount('/', HTTPServlet::FileHandler, './docroot')

server.mount_proc('/page') do |request, response|
  name = request.cookies.empty? ? DEFAULT_NAME : names[request.cookies[0].value.to_i]
  response['Content-Type'] = 'text/html'
  response.body = page.result(binding)
end

server.mount_proc('/save_name') do |request, response|
  response['Content-Type'] = 'text/plain'
  if 0 == rand(4)
    response.body = '501 Could not be saved.'
	next
  end
  if request.cookies.empty?
    sessionGen += 1
	session_id = sessionGen
    cookie = Cookie.new('session_id', session_id.to_s)
	cookie.expires = Time.utc(2010, 12, 31)
    response.cookies << cookie
  else
    session_id = request.cookies[0].value.to_i
  end
  names[session_id] = request.query['name']
  response.body = '200 Saved.'
end

trap('INT') { server.shutdown }

srand
server.start
