#! /usr/bin/env ruby

require 'cgi'
require 'erb'
require 'webrick'
include WEBrick

PRODUCT_LABELS = {
	'1' => 'Mug',
	'2' => 'T-shirt'
}

cart = {}

template_text = File.read('cart.rhtml')
cart_html = ERB.new(template_text)

server = HTTPServer.new(:Port => 8042)
server.mount('/', HTTPServlet::FileHandler, './docroot')

server.mount_proc('/add') do |request, response|
  product_id = CGI::parse(request.body)['id'][0]
  cart[product_id] = cart.include?(product_id) ? cart[product_id ] + 1 : 1
  sleep 1 # Simuler un A/R web, qu'on voie l'indicateur...
  response['Content-Type'] = 'text/html'
  response.body = cart_html.result(binding)
end

server.mount_proc('/remove') do |request, response|
  product_id = CGI::parse(request.body)['id'][0]
  if cart[product_id] > 1
    cart[product_id] = cart[product_id] -1
  else
    cart.delete(product_id)
  end
  sleep 1
  response['Content-Type'] = 'text/html'
  response.body = cart_html.result(binding)
end

trap('INT') { server.shutdown }

server.start
