/*
 * Script d'insertion de fragment XHTML  l'aide de Ajax.Updater.
 * Version "fancy" pour l'exemple avec script.aculo.us
 *
 * Ncessite Prototype 1.4+
 */

function bindForm() {
	Event.observe($('commentForm'), 'submit', switchToAJAX);
} // bindForm

function switchToAJAX(e) {
	Event.stop(e);
	var data = $H({
		'name': $F('edtName'),
		'email': $F('edtEmail'),
		'comment': $F('memComment')
	}).toQueryString();
	new Ajax.Updater('comments', '/add_comment',
	{
		postBody: data,
		insertion: Insertion.Bottom,
		onComplete: function() {
			var comments = $$('#comments .comment');
			var commentCount = comments.length;
			var lastComment = comments.last();
			var text = commentCount + ' commentaire';
			if (commentCount > 1)
				text += 's';
			Element.update('commentCount', text);
			new Effect.Parallel([
				new Effect.Pulsate('commentCount', { sync: true }),
				new Effect.BlindDown(lastComment, { sync: true })
			], { duration: 2 });
		}
	});
} // switchToAJAX

Event.observe(window, 'load', bindForm);
