<?xml version="1.0" encoding="iso-8859-15"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <xsl:apply-templates select="/rsp/photoset"/>
        <xsl:apply-templates select="/rsp/err"/>
    </xsl:template>
    <xsl:template match="photoset">
        <div id="photoset">
            <xsl:element name="img">
                <xsl:attribute name="id">
                    <xsl:value-of select="@id"/>
                </xsl:attribute>
                <xsl:attribute name="src">
                    http://static.flickr.com/<xsl:value-of select="@server"/>/<xsl:value-of select="@primary"/>_<xsl:value-of select="@secret"/>_m.jpg
                </xsl:attribute>
            </xsl:element>
            <h1><xsl:value-of select="title"/></h1>
            <p class="description"><xsl:value-of select="description"/></p>
            <p class="photoCount">
                <xsl:value-of select="@photos"/>
                photo<xsl:if test="@photos &gt; 1">s</xsl:if>
                de
                <span id="photoset-owner"></span>
            </p>
        </td>
    </xsl:template>
    <xsl:template match="err">
        <p class="error">
            Erreur n&deg; <xsl:value-of select="@code"/>&nbsp;:
            <xsl:value-of select="@msg"/>
        </p>
    </xsl:template>
</xsl:stylesheet>
