#! /usr/bin/env ruby

require 'net/http'
require 'uri'
require 'webrick'
include WEBrick

server = HTTPServer.new(:Port => 8042)
server.mount('/', HTTPServlet::FileHandler, './docroot')

def get_requester
  if ENV.has_key?('http_proxy')
    comps = ENV['http_proxy'].split(':')
    host, port = comps[0..-2].join(':'), comps[-1]
    host.sub!(/^https?:\/\//i, '')
    port = port.to_i rescue 80
    Net::HTTP::Proxy(host, port)
  else
    Net::HTTP
  end
end # get_requester

server.mount_proc('/xmlProxy') do |request, response|
  res = get_requester.get_response(URI.parse(request.query['url']))
  if res['Content-Type'] =~ /xml/
  	response['Content-Type'] = res['Content-Type']
  else
  	ct = 'text/xml'
  	if res.body =~ /^<\?xml .*? encoding="(.*?)"\?>/
  	  ct += '; charset=' + $1
  	end
  	response['Content-Type'] = ct
  end
  response.body = res.body
end

trap('INT') { server.shutdown }

server.start
